/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.core.mixin;

import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.proxy.CommonProxy;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={EntityLivingBase.class})
public abstract class EntityLivingBaseMixin
extends Entity {
    public EntityLivingBaseMixin(World worldIn) {
        super(worldIn);
    }

    @Accessor(value="isJumping")
    public abstract boolean aqua$isJumping();

    @Redirect(method={"travel"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;isSneaking()Z"))
    public boolean isSneaking(EntityLivingBase entity) {
        if (entity instanceof IPlayerResizeable) {
            return ((IPlayerResizeable)entity).isActuallySneaking();
        }
        return this.func_70093_af();
    }

    private boolean aqua$isLosingAir() {
        if (ConfigHandler.MiscellaneousConfig.bubbleColumns && this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v)).func_177230_c() == CommonProxy.BUBBLE_COLUMN) {
            return false;
        }
        return this.func_70055_a(Material.field_151586_h);
    }

    @Redirect(method={"onEntityUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;isInsideOfMaterial(Lnet/minecraft/block/material/Material;)Z"))
    private boolean checkBubbleBreathing(EntityLivingBase entityLivingBase, Material materialIn) {
        if (materialIn == Material.field_151586_h) {
            return this.aqua$isLosingAir();
        }
        return entityLivingBase.func_70055_a(materialIn);
    }

    @ModifyArg(method={"onEntityUpdate"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/EntityLivingBase;setAir(I)V"), index=0)
    private int getNewAirValue(int original) {
        if (ConfigHandler.MiscellaneousConfig.slowAirReplenish && original == 300 && this.func_70086_ai() >= -20 && !this.aqua$isLosingAir()) {
            int oldAirValue = Math.max(this.func_70086_ai(), 0);
            return Math.min(oldAirValue + 4, 300);
        }
        return original;
    }

    @Redirect(method={"travel"}, at=@At(value="FIELD", opcode=180, target="Lnet/minecraft/entity/EntityLivingBase;collidedHorizontally:Z", ordinal=1))
    private boolean isJumpingOnLadder(EntityLivingBase instance) {
        if (ConfigHandler.MovementConfig.newClimbingBehavior) {
            return instance.field_70123_F || ((EntityLivingBaseMixin)instance).aqua$isJumping();
        }
        return instance.field_70123_F;
    }
}

