/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.integration.artemislib;

import com.artemis.artemislib.util.AttachAttributes;
import com.artemis.artemislib.util.attributes.ArtemisLibAttributes;
import com.fuzs.aquaacrobatics.core.mixin.accessor.IEventBusAccessor;
import com.fuzs.aquaacrobatics.entity.Pose;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.artemislib.AttachAttributesFix;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;

public class ArtemisLibIntegration {
    private static final UUID SWIMMING_HEIGHT_ID = UUID.fromString("F5ED4D20-4DAB-11EB-AE93-0242AC130002");
    private static final AttributeModifier SWIMMING_HEIGHT = new AttributeModifier(SWIMMING_HEIGHT_ID, "Swimming height modifier", -0.6666666666666666, 2);

    public static void register() {
        Optional<Object> optional = ((IEventBusAccessor)MinecraftForge.EVENT_BUS).getListeners().keySet().stream().filter(key -> key instanceof AttachAttributes).findFirst();
        if (optional.isPresent()) {
            MinecraftForge.EVENT_BUS.unregister(optional.get());
            MinecraftForge.EVENT_BUS.register((Object)new AttachAttributesFix());
        }
    }

    public static void updateSwimmingSize(EntityPlayer player, Pose pose) {
        IAttributeInstance iattributeinstance = player.func_110148_a(ArtemisLibAttributes.ENTITY_HEIGHT);
        if (iattributeinstance.func_111127_a(SWIMMING_HEIGHT_ID) != null) {
            iattributeinstance.func_111124_b(SWIMMING_HEIGHT);
        }
        if (pose == Pose.SWIMMING) {
            iattributeinstance.func_111121_a(SWIMMING_HEIGHT);
        }
    }

    public static float getEyeFactor(EntityPlayer player) {
        if (((IPlayerResizeable)player).getPose() == Pose.SWIMMING) {
            double heightAttribute = player.func_110140_aT().func_111151_a(ArtemisLibAttributes.ENTITY_HEIGHT).func_111126_e();
            return (float)(heightAttribute * 3.0);
        }
        return 1.0f;
    }
}

