/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.aquaacrobatics.proxy;

import com.fuzs.aquaacrobatics.block.BlockBubbleColumn;
import com.fuzs.aquaacrobatics.client.handler.AirMeterHandler;
import com.fuzs.aquaacrobatics.client.handler.FogHandler;
import com.fuzs.aquaacrobatics.client.model.WaterResourcePack;
import com.fuzs.aquaacrobatics.config.ConfigHandler;
import com.fuzs.aquaacrobatics.entity.player.IPlayerResizeable;
import com.fuzs.aquaacrobatics.integration.IntegrationManager;
import com.fuzs.aquaacrobatics.integration.artemislib.ArtemisLibIntegration;
import com.fuzs.aquaacrobatics.integration.enderio.EnderIOIntegration;
import com.fuzs.aquaacrobatics.integration.mobends.MoBendsIntegration;
import com.fuzs.aquaacrobatics.integration.thaumicaugmentation.ThaumicAugmentationIntegration;
import com.fuzs.aquaacrobatics.network.NetworkHandler;
import com.fuzs.aquaacrobatics.network.message.PacketSendKey;
import com.fuzs.aquaacrobatics.optifine.OptifineHelper;
import com.fuzs.aquaacrobatics.proxy.CommonProxy;
import com.fuzs.aquaacrobatics.util.Keybindings;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    @Override
    public void onPreInit(FMLPreInitializationEvent event) {
        super.onPreInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new AirMeterHandler());
        MinecraftForge.EVENT_BUS.register((Object)new FogHandler());
        if (ConfigHandler.BlocksConfig.newWaterColors) {
            List packs = (List)ObfuscationReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String)"field_110449_ao");
            packs.add(new WaterResourcePack(event.getSourceFile()));
            FMLClientHandler.instance().refreshResources(new IResourceType[]{VanillaResourceType.TEXTURES});
            OptifineHelper.init();
        }
    }

    @Override
    public void onInit() {
        Keybindings.register();
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (ConfigHandler.MiscellaneousConfig.bubbleColumns) {
            ModelLoader.setCustomStateMapper((Block)CommonProxy.BUBBLE_COLUMN, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLiquid.field_176367_b, BlockBubbleColumn.DRAG}).func_178441_a());
        }
    }

    @SubscribeEvent
    public static void registerTextures(TextureStitchEvent.Pre event) {
        if (ConfigHandler.BlocksConfig.newWaterColors) {
            TextureMap map = event.getMap();
            map.func_174942_a(new ResourceLocation("aquaacrobatics:blocks/water_still"));
            map.func_174942_a(new ResourceLocation("aquaacrobatics:blocks/water_flow"));
        }
    }

    @SubscribeEvent
    public static void onKeyPress(InputEvent.KeyInputEvent event) {
        IPlayerResizeable player;
        if (ConfigHandler.MovementConfig.enableToggleCrawling && Keybindings.forceCrawling.func_151468_f() && (player = (IPlayerResizeable)Minecraft.func_71410_x().field_71439_g) != null) {
            if (player.canForceCrawling()) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketSendKey(PacketSendKey.KeybindPacket.TOGGLE_CRAWLING));
            } else {
                ((EntityPlayerSP)player).func_145747_a((ITextComponent)new TextComponentTranslation("chat.aquaacrobatics.cannot_toggle_crawling", new Object[0]));
            }
        }
    }

    @Override
    public void onPostInit() {
        super.onPostInit();
        FogHandler.recomputeBlacklist();
        if (IntegrationManager.isMoBendsEnabled()) {
            MoBendsIntegration.register();
        }
        if (IntegrationManager.isArtemisLibEnabled()) {
            ArtemisLibIntegration.register();
        }
        if (IntegrationManager.isEnderIoEnabled()) {
            EnderIOIntegration.register();
        }
        if (IntegrationManager.isThaumicAugmentationEnabled()) {
            ThaumicAugmentationIntegration.register();
        }
    }
}

