/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.block.state.pattern;

import com.github.lunatrius.core.exceptions.LocalizedException;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.util.ResourceLocation;

public class BlockStateReplacer {
    private final IBlockState defaultReplacement;

    private BlockStateReplacer(IBlockState defaultReplacement) {
        this.defaultReplacement = defaultReplacement;
    }

    public IBlockState getReplacement(IBlockState original, Map<IProperty, Comparable> properties) {
        IBlockState replacement = this.defaultReplacement;
        replacement = this.applyProperties(replacement, (Map)original.func_177228_b());
        replacement = this.applyProperties(replacement, properties);
        return replacement;
    }

    private <K extends IProperty, V extends Comparable> IBlockState applyProperties(IBlockState blockState, Map<K, V> properties) {
        for (Map.Entry<K, V> entry : properties.entrySet()) {
            try {
                blockState = blockState.func_177226_a((IProperty)entry.getKey(), (Comparable)entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return blockState;
    }

    public static BlockStateReplacer forBlockState(IBlockState replacement) {
        return new BlockStateReplacer(replacement);
    }

    public static BlockStateMatcher getMatcher(BlockStateInfo blockStateInfo) {
        BlockStateMatcher matcher = BlockStateMatcher.func_177638_a((Block)blockStateInfo.block);
        for (final Map.Entry<IProperty, Comparable> entry : blockStateInfo.stateData.entrySet()) {
            matcher.func_177637_a(entry.getKey(), (Predicate)new Predicate<Comparable>(){

                public boolean apply(Comparable input) {
                    return input != null && input.equals(entry.getValue());
                }
            });
        }
        return matcher;
    }

    public static BlockStateInfo fromString(String input) throws LocalizedException {
        String stateData;
        String blockName;
        int start = input.indexOf(91);
        int end = input.indexOf(93);
        if (start > -1 && end > -1) {
            blockName = input.substring(0, start);
            stateData = input.substring(start + 1, end);
        } else {
            blockName = input;
            stateData = "";
        }
        ResourceLocation location = new ResourceLocation(blockName);
        if (!Block.field_149771_c.func_148741_d((Object)location)) {
            throw new LocalizedException("schematica.message.invalidBlock", new Object[]{blockName});
        }
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        Map<IProperty, Comparable> propertyData = BlockStateReplacer.parsePropertyData(block.func_176223_P(), stateData, true);
        return new BlockStateInfo(block, propertyData);
    }

    public static Map<IProperty, Comparable> parsePropertyData(IBlockState blockState, String stateData, boolean strict) throws LocalizedException {
        String[] propertyPairs;
        HashMap<IProperty, Comparable> map = new HashMap<IProperty, Comparable>();
        if (stateData == null || stateData.length() == 0) {
            return map;
        }
        for (String propertyPair : propertyPairs = stateData.split(",")) {
            String[] split = propertyPair.split("=");
            if (split.length != 2) {
                throw new LocalizedException("schematica.message.invalidProperty", new Object[]{propertyPair});
            }
            BlockStateReplacer.putMatchingProperty(map, blockState, split[0], split[1], strict);
        }
        return map;
    }

    private static boolean putMatchingProperty(Map<IProperty, Comparable> map, IBlockState blockState, String name, String value, boolean strict) throws LocalizedException {
        for (IProperty property : blockState.func_177227_a()) {
            if (!property.func_177701_a().equalsIgnoreCase(name)) continue;
            Collection allowedValues = property.func_177700_c();
            for (Comparable allowedValue : allowedValues) {
                if (!String.valueOf(allowedValue).equalsIgnoreCase(value)) continue;
                map.put(property, allowedValue);
                return true;
            }
        }
        if (strict) {
            throw new LocalizedException("schematica.message.invalidPropertyForBlock", new Object[]{name + "=" + value, Block.field_149771_c.func_177774_c((Object)blockState.func_177230_c())});
        }
        return false;
    }

    public static class BlockStateInfo {
        public final Block block;
        public final Map<IProperty, Comparable> stateData;

        public BlockStateInfo(Block block, Map<IProperty, Comparable> stateData) {
            this.block = block;
            this.stateData = stateData;
        }
    }
}

