/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.client.renderer.chunk.overlay;

import com.github.lunatrius.core.client.renderer.GeometryTessellator;
import com.github.lunatrius.schematica.client.renderer.chunk.CompiledOverlay;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.ChunkCompileTaskGenerator;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;

public class RenderOverlay
extends RenderChunk {
    private final VertexBuffer vertexBuffer = OpenGlHelper.func_176075_f() ? new VertexBuffer(DefaultVertexFormats.field_181706_f) : null;

    public RenderOverlay(World world, RenderGlobal renderGlobal, int index) {
        super(world, renderGlobal, index);
    }

    public VertexBuffer func_178565_b(int layer) {
        return this.vertexBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float x, float y, float z, ChunkCompileTaskGenerator generator) {
        ChunkCache chunkCache;
        CompiledOverlay compiledOverlay = new CompiledOverlay();
        BlockPos from = this.func_178568_j();
        BlockPos to = from.func_177982_a(15, 15, 15);
        BlockPos fromEx = from.func_177982_a(-1, -1, -1);
        BlockPos toEx = to.func_177982_a(1, 1, 1);
        generator.func_178540_f().lock();
        SchematicWorld schematic = (SchematicWorld)this.field_178588_d;
        try {
            if (generator.func_178546_a() != ChunkCompileTaskGenerator.Status.COMPILING) {
                return;
            }
            if (from.func_177958_n() < 0 || from.func_177952_p() < 0 || from.func_177958_n() >= schematic.getWidth() || from.func_177952_p() >= schematic.getLength()) {
                generator.func_178543_a(CompiledChunk.field_178502_a);
                return;
            }
            chunkCache = new ChunkCache(this.field_178588_d, fromEx, toEx, 1);
            generator.func_178543_a((CompiledChunk)compiledOverlay);
        }
        finally {
            generator.func_178540_f().unlock();
        }
        VisGraph visgraph = new VisGraph();
        if (!chunkCache.func_72806_N()) {
            int secZ;
            int secY;
            int secX;
            ++field_178592_a;
            WorldClient mcWorld = Minecraft.func_71410_x().field_71441_e;
            BlockRenderLayer layer = BlockRenderLayer.TRANSLUCENT;
            BufferBuilder buffer = generator.func_178545_d().func_179038_a(layer);
            GeometryTessellator.setStaticDelta((double)ConfigurationHandler.blockDelta);
            BlockType[][][] types = new BlockType[18][18][18];
            BlockPos.MutableBlockPos mcPos = new BlockPos.MutableBlockPos();
            for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)fromEx, (BlockPos)toEx)) {
                boolean isMcAirBlock;
                if (!schematic.isInside((BlockPos)pos) || !schematic.layerMode.shouldUseLayer(schematic, pos.func_177956_o())) continue;
                secX = pos.func_177958_n() - fromEx.func_177958_n();
                secY = pos.func_177956_o() - fromEx.func_177956_o();
                secZ = pos.func_177952_p() - fromEx.func_177952_p();
                IBlockState schBlockState = schematic.func_180495_p((BlockPos)pos);
                Block schBlock = schBlockState.func_177230_c();
                if (schBlockState.func_185914_p()) {
                    visgraph.func_178606_a((BlockPos)pos);
                }
                mcPos.func_181079_c(pos.func_177958_n() + schematic.position.func_177958_n(), pos.func_177956_o() + schematic.position.func_177956_o(), pos.func_177952_p() + schematic.position.func_177952_p());
                IBlockState mcBlockState = mcWorld.func_180495_p((BlockPos)mcPos);
                Block mcBlock = mcBlockState.func_177230_c();
                boolean isSchAirBlock = schematic.func_175623_d((BlockPos)pos);
                boolean bl = isMcAirBlock = mcWorld.func_175623_d((BlockPos)mcPos) || ConfigurationHandler.isExtraAirBlock(mcBlock);
                if (ConfigurationHandler.highlightAir && !isMcAirBlock && isSchAirBlock) {
                    types[secX][secY][secZ] = BlockType.EXTRA_BLOCK;
                    continue;
                }
                if (!ConfigurationHandler.highlight) continue;
                if (!isMcAirBlock) {
                    if (schBlock != mcBlock) {
                        types[secX][secY][secZ] = BlockType.WRONG_BLOCK;
                        continue;
                    }
                    if (schBlock.func_176201_c(schBlockState) == mcBlock.func_176201_c(mcBlockState)) continue;
                    types[secX][secY][secZ] = BlockType.WRONG_META;
                    continue;
                }
                if (isSchAirBlock) continue;
                types[secX][secY][secZ] = BlockType.MISSING_BLOCK;
            }
            for (BlockPos.MutableBlockPos pos : BlockPos.func_177975_b((BlockPos)from, (BlockPos)to)) {
                secX = pos.func_177958_n() - fromEx.func_177958_n();
                BlockType type = types[secX][secY = pos.func_177956_o() - fromEx.func_177956_o()][secZ = pos.func_177952_p() - fromEx.func_177952_p()];
                if (type == null) continue;
                if (!compiledOverlay.func_178492_d(layer)) {
                    compiledOverlay.func_178493_c(layer);
                    this.func_178573_a(buffer, from);
                }
                int sides = this.getSides(types, secX, secY, secZ);
                GeometryTessellator.drawCuboid((BufferBuilder)buffer, (BlockPos)pos, (int)sides, (int)(0x3F000000 | type.color));
                compiledOverlay.func_178486_a(layer);
            }
            if (compiledOverlay.func_178492_d(layer)) {
                this.func_178584_a(layer, x, y, z, buffer, compiledOverlay);
            }
        }
        compiledOverlay.func_178488_a(visgraph.func_178607_a());
    }

    private int getSides(BlockType[][][] types, int x, int y, int z) {
        if (x <= 0 || x >= 17) {
            throw new IndexOutOfBoundsException("x cannot be in padding: " + x);
        }
        if (y <= 0 || y >= 17) {
            throw new IndexOutOfBoundsException("y cannot be in padding: " + y);
        }
        if (z <= 0 || z >= 17) {
            throw new IndexOutOfBoundsException("z cannot be in padding: " + z);
        }
        int sides = 0;
        BlockType type = types[x][y][z];
        if (types[x][y - 1][z] != type) {
            sides |= 1;
        }
        if (types[x][y + 1][z] != type) {
            sides |= 2;
        }
        if (types[x][y][z - 1] != type) {
            sides |= 4;
        }
        if (types[x][y][z + 1] != type) {
            sides |= 8;
        }
        if (types[x - 1][y][z] != type) {
            sides |= 0x10;
        }
        if (types[x + 1][y][z] != type) {
            sides |= 0x20;
        }
        return sides;
    }

    public void func_178573_a(BufferBuilder buffer, BlockPos pos) {
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_178969_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
    }

    public void func_178566_a() {
        super.func_178566_a();
        if (this.vertexBuffer != null) {
            this.vertexBuffer.func_177362_c();
        }
    }

    private static enum BlockType {
        EXTRA_BLOCK(0xBF00BF),
        WRONG_BLOCK(0xFF0000),
        WRONG_META(12541696),
        MISSING_BLOCK(49151);

        public final int color;

        private BlockType(int color) {
            this.color = color;
        }
    }
}

