/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.command.client;

import com.github.lunatrius.schematica.block.state.pattern.BlockStateReplacer;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.command.CommandSchematicaBase;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class CommandSchematicaReplace
extends CommandSchematicaBase {
    public String func_71517_b() {
        return "schematicaReplace";
    }

    public String func_71518_a(ICommandSender sender) {
        return "schematica.command.replace.usage";
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length < 3) {
            return CommandSchematicaReplace.func_175762_a((String[])args, (Collection)Block.field_149771_c.func_148742_b());
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        SchematicWorld schematic = ClientProxy.schematic;
        if (schematic == null) {
            throw new CommandException("schematica.command.replace.noSchematic", new Object[0]);
        }
        if (args.length != 2) {
            throw new CommandException("schematica.command.replace.usage", new Object[0]);
        }
        try {
            BlockStateReplacer.BlockStateInfo patternInfo = BlockStateReplacer.fromString(args[0]);
            BlockStateMatcher matcher = BlockStateReplacer.getMatcher(patternInfo);
            BlockStateReplacer.BlockStateInfo replacementInfo = BlockStateReplacer.fromString(args[1]);
            BlockStateReplacer replacer = BlockStateReplacer.forBlockState(replacementInfo.block.func_176223_P());
            int count = schematic.replaceBlock(matcher, replacer, replacementInfo.stateData);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("schematica.command.replace.success", new Object[]{count}));
        }
        catch (Exception e) {
            Reference.logger.error("Something went wrong!", (Throwable)e);
            throw new CommandException(e.getMessage(), new Object[0]);
        }
    }
}

