/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler;

import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.network.PacketHandler;
import com.github.lunatrius.schematica.network.message.MessageDownloadBegin;
import com.github.lunatrius.schematica.network.message.MessageDownloadChunk;
import com.github.lunatrius.schematica.network.message.MessageDownloadEnd;
import com.github.lunatrius.schematica.network.transfer.SchematicTransfer;
import com.github.lunatrius.schematica.reference.Reference;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DownloadHandler {
    public static final DownloadHandler INSTANCE = new DownloadHandler();
    public ISchematic schematic = null;
    public final Map<EntityPlayerMP, SchematicTransfer> transferMap = new LinkedHashMap<EntityPlayerMP, SchematicTransfer>();

    private DownloadHandler() {
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        this.processQueue();
    }

    private void processQueue() {
        if (this.transferMap.size() == 0) {
            return;
        }
        EntityPlayerMP player = this.transferMap.keySet().iterator().next();
        SchematicTransfer transfer = this.transferMap.remove(player);
        if (transfer == null) {
            return;
        }
        if (!transfer.state.isWaiting()) {
            if (++transfer.timeout >= 300) {
                if (++transfer.retries >= 5) {
                    Reference.logger.warn("{}'s download was dropped!", (Object)player.func_70005_c_());
                    return;
                }
                Reference.logger.warn("{}'s download timed out, retrying (#{})", (Object)player.func_70005_c_(), (Object)transfer.retries);
                this.sendChunk(player, transfer);
                transfer.timeout = 0;
            }
        } else if (transfer.state == SchematicTransfer.State.BEGIN_WAIT) {
            this.sendBegin(player, transfer);
        } else if (transfer.state == SchematicTransfer.State.CHUNK_WAIT) {
            this.sendChunk(player, transfer);
        } else if (transfer.state == SchematicTransfer.State.END_WAIT) {
            this.sendEnd(player, transfer);
            return;
        }
        this.transferMap.put(player, transfer);
    }

    private void sendBegin(EntityPlayerMP player, SchematicTransfer transfer) {
        transfer.setState(SchematicTransfer.State.BEGIN);
        MessageDownloadBegin message = new MessageDownloadBegin(transfer.schematic);
        PacketHandler.INSTANCE.sendTo((IMessage)message, player);
    }

    private void sendChunk(EntityPlayerMP player, SchematicTransfer transfer) {
        transfer.setState(SchematicTransfer.State.CHUNK);
        Reference.logger.trace("Sending chunk {},{},{}", (Object)transfer.baseX, (Object)transfer.baseY, (Object)transfer.baseZ);
        MessageDownloadChunk message = new MessageDownloadChunk(transfer.schematic, transfer.baseX, transfer.baseY, transfer.baseZ);
        PacketHandler.INSTANCE.sendTo((IMessage)message, player);
    }

    private void sendEnd(EntityPlayerMP player, SchematicTransfer transfer) {
        MessageDownloadEnd message = new MessageDownloadEnd(transfer.name);
        PacketHandler.INSTANCE.sendTo((IMessage)message, player);
    }
}

