/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.proxy;

import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.core.util.vector.Vector3d;
import com.github.lunatrius.schematica.api.ISchematic;
import com.github.lunatrius.schematica.client.printer.SchematicPrinter;
import com.github.lunatrius.schematica.client.renderer.RenderSchematic;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.command.client.CommandSchematicaReplace;
import com.github.lunatrius.schematica.handler.ConfigurationHandler;
import com.github.lunatrius.schematica.handler.client.GuiHandler;
import com.github.lunatrius.schematica.handler.client.InputHandler;
import com.github.lunatrius.schematica.handler.client.OverlayHandler;
import com.github.lunatrius.schematica.handler.client.RenderTickHandler;
import com.github.lunatrius.schematica.handler.client.TickHandler;
import com.github.lunatrius.schematica.handler.client.WorldHandler;
import com.github.lunatrius.schematica.proxy.CommonProxy;
import com.github.lunatrius.schematica.reference.Reference;
import com.github.lunatrius.schematica.world.schematic.SchematicFormat;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ClientProxy
extends CommonProxy {
    public static boolean isRenderingGuide = false;
    public static boolean isPendingReset = false;
    public static final Vector3d playerPosition = new Vector3d();
    public static EnumFacing orientation = null;
    public static int rotationRender = 0;
    public static SchematicWorld schematic = null;
    public static final MBlockPos pointA = new MBlockPos();
    public static final MBlockPos pointB = new MBlockPos();
    public static final MBlockPos pointMin = new MBlockPos();
    public static final MBlockPos pointMax = new MBlockPos();
    public static EnumFacing axisFlip = EnumFacing.UP;
    public static EnumFacing axisRotation = EnumFacing.UP;
    public static RayTraceResult objectMouseOver = null;
    private static final Minecraft MINECRAFT = Minecraft.func_71410_x();

    public static void setPlayerData(EntityPlayer player, float partialTicks) {
        ClientProxy.playerPosition.x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        ClientProxy.playerPosition.y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        ClientProxy.playerPosition.z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        orientation = ClientProxy.getOrientation(player);
        rotationRender = MathHelper.func_76141_d((float)(player.field_70177_z / 90.0f)) & 3;
    }

    private static EnumFacing getOrientation(EntityPlayer player) {
        if (player.field_70125_A > 45.0f) {
            return EnumFacing.DOWN;
        }
        if (player.field_70125_A < -45.0f) {
            return EnumFacing.UP;
        }
        switch (MathHelper.func_76128_c((double)((double)player.field_70177_z / 90.0 + 0.5)) & 3) {
            case 0: {
                return EnumFacing.SOUTH;
            }
            case 1: {
                return EnumFacing.WEST;
            }
            case 2: {
                return EnumFacing.NORTH;
            }
            case 3: {
                return EnumFacing.EAST;
            }
        }
        return null;
    }

    public static void updatePoints() {
        ClientProxy.pointMin.field_177962_a = Math.min(ClientProxy.pointA.field_177962_a, ClientProxy.pointB.field_177962_a);
        ClientProxy.pointMin.field_177960_b = Math.min(ClientProxy.pointA.field_177960_b, ClientProxy.pointB.field_177960_b);
        ClientProxy.pointMin.field_177961_c = Math.min(ClientProxy.pointA.field_177961_c, ClientProxy.pointB.field_177961_c);
        ClientProxy.pointMax.field_177962_a = Math.max(ClientProxy.pointA.field_177962_a, ClientProxy.pointB.field_177962_a);
        ClientProxy.pointMax.field_177960_b = Math.max(ClientProxy.pointA.field_177960_b, ClientProxy.pointB.field_177960_b);
        ClientProxy.pointMax.field_177961_c = Math.max(ClientProxy.pointA.field_177961_c, ClientProxy.pointB.field_177961_c);
    }

    public static void movePointToPlayer(MBlockPos point) {
        point.field_177962_a = (int)Math.floor(ClientProxy.playerPosition.x);
        point.field_177960_b = (int)Math.floor(ClientProxy.playerPosition.y);
        point.field_177961_c = (int)Math.floor(ClientProxy.playerPosition.z);
        switch (rotationRender) {
            case 0: {
                --point.field_177962_a;
                ++point.field_177961_c;
                break;
            }
            case 1: {
                --point.field_177962_a;
                --point.field_177961_c;
                break;
            }
            case 2: {
                ++point.field_177962_a;
                --point.field_177961_c;
                break;
            }
            case 3: {
                ++point.field_177962_a;
                ++point.field_177961_c;
            }
        }
    }

    public static void moveSchematicToPlayer(SchematicWorld schematic) {
        if (schematic != null) {
            MBlockPos position = schematic.position;
            position.field_177962_a = (int)Math.floor(ClientProxy.playerPosition.x);
            position.field_177960_b = (int)Math.floor(ClientProxy.playerPosition.y);
            position.field_177961_c = (int)Math.floor(ClientProxy.playerPosition.z);
            switch (rotationRender) {
                case 0: {
                    position.field_177962_a -= schematic.getWidth();
                    ++position.field_177961_c;
                    break;
                }
                case 1: {
                    position.field_177962_a -= schematic.getWidth();
                    position.field_177961_c -= schematic.getLength();
                    break;
                }
                case 2: {
                    ++position.field_177962_a;
                    position.field_177961_c -= schematic.getLength();
                    break;
                }
                case 3: {
                    ++position.field_177962_a;
                    ++position.field_177961_c;
                }
            }
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Property[] sliders;
        super.preInit(event);
        for (Property property : sliders = new Property[]{ConfigurationHandler.propAlpha, ConfigurationHandler.propBlockDelta, ConfigurationHandler.propRenderDistance, ConfigurationHandler.propPlaceDelay, ConfigurationHandler.propTimeout, ConfigurationHandler.propPlaceDistance}) {
            property.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        }
        for (Property property : InputHandler.KEY_BINDINGS) {
            ClientRegistry.registerKeyBinding((KeyBinding)property);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)InputHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)TickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RenderTickHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ConfigurationHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RenderSchematic.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)GuiHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new OverlayHandler());
        MinecraftForge.EVENT_BUS.register((Object)new WorldHandler());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandSchematicaReplace());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        this.resetSettings();
    }

    @Override
    public File getDataDirectory() {
        File file = ClientProxy.MINECRAFT.field_71412_D;
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            Reference.logger.debug("Could not canonize path!", (Throwable)e);
            return file;
        }
    }

    @Override
    public void resetSettings() {
        super.resetSettings();
        SchematicPrinter.INSTANCE.setEnabled(true);
        this.unloadSchematic();
        isRenderingGuide = false;
        playerPosition.set(0.0, 0.0, 0.0);
        orientation = null;
        rotationRender = 0;
        pointA.set(0, 0, 0);
        pointB.set(0, 0, 0);
        ClientProxy.updatePoints();
    }

    @Override
    public void unloadSchematic() {
        schematic = null;
        RenderSchematic.INSTANCE.setWorldAndLoadRenderers(null);
        SchematicPrinter.INSTANCE.setSchematic(null);
    }

    @Override
    public boolean loadSchematic(EntityPlayer player, File directory, String filename) {
        ISchematic schematic = SchematicFormat.readFromFile(directory, filename);
        if (schematic == null) {
            return false;
        }
        SchematicWorld world = new SchematicWorld(schematic);
        Reference.logger.debug("Loaded {} [w:{},h:{},l:{}]", (Object)filename, (Object)world.getWidth(), (Object)world.func_72800_K(), (Object)world.getLength());
        ClientProxy.schematic = world;
        RenderSchematic.INSTANCE.setWorldAndLoadRenderers(world);
        SchematicPrinter.INSTANCE.setSchematic(world);
        world.isRendering = true;
        return true;
    }

    @Override
    public boolean isPlayerQuotaExceeded(EntityPlayer player) {
        return false;
    }

    @Override
    public File getPlayerSchematicDirectory(EntityPlayer player, boolean privateDirectory) {
        return ConfigurationHandler.schematicDirectory;
    }
}

