/*
 * Decompiled with CFR 0.152.
 */
package me.lorexe.jepb.proxy;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lorexe.jepb.jei.banners.shapes.RecipeShapesBanner;
import me.lorexe.jepb.jei.banners.symbols.RecipeSymbolsBanner;
import me.lorexe.jepb.mods.IEHandler;
import me.lorexe.jepb.mods.IModHandler;
import net.minecraft.tileentity.BannerPattern;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CommonProxy {
    public List<RecipeShapesBanner> shapesBannerRecipe;
    public List<RecipeSymbolsBanner> symbolsBannerRecipe;
    public Configuration config;
    public int baseColor;
    public int patternColor;
    public Map<String, IModHandler> modHandlers;

    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.loadConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.modHandlers = new HashMap<String, IModHandler>();
        this.modHandlers.put("immersiveengineering", new IEHandler());
        ImmutableList.Builder builderShapes = ImmutableList.builder();
        ImmutableList.Builder builderSymbols = ImmutableList.builder();
        for (BannerPattern p : BannerPattern.values()) {
            if (p.func_191000_d() && !p.func_190999_e()) {
                builderShapes.add((Object)new RecipeShapesBanner(p.func_190993_b(), p.func_190996_c()));
                continue;
            }
            if (!p.func_190999_e()) continue;
            builderSymbols.add((Object)new RecipeSymbolsBanner(p.func_190993_b(), p.func_190998_f()));
        }
        for (Map.Entry entry : this.modHandlers.entrySet()) {
            String modID = (String)entry.getKey();
            IModHandler handler = (IModHandler)entry.getValue();
            if (!Loader.isModLoaded((String)modID)) continue;
            handler.register((ImmutableList.Builder<RecipeShapesBanner>)builderShapes, (ImmutableList.Builder<RecipeSymbolsBanner>)builderSymbols);
        }
        this.shapesBannerRecipe = builderShapes.build();
        this.symbolsBannerRecipe = builderSymbols.build();
    }

    public void loadConfig() {
        String desc = "Base color of the banner in JEI [range: 0 ~ 15, default: 0]";
        this.baseColor = this.config.get("general", "baseColor", 15, desc, 0, 15).getInt();
        desc = "Pattern color on the banner in JEI [range: 0 ~ 15, default: 0]";
        this.patternColor = this.config.get("general", "patternColor", 0, desc, 0, 15).getInt();
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equals("jepb")) {
            this.loadConfig();
        }
    }
}

