/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import micdoodle8.mods.galacticraft.api.event.ZeroGravityEvent;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.TransformerHooks;
import micdoodle8.mods.galacticraft.core.dimension.SpinManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FreefallHandler {
    private double pPrevMotionX;
    public double pPrevMotionY;
    private double pPrevMotionZ;
    private float jetpackBoost;
    private double pPrevdY;
    public boolean sneakLast;
    public boolean onWall;
    public int pjumpticks = 0;
    private GCPlayerStatsClient stats;

    public FreefallHandler(GCPlayerStatsClient statsClientCapability) {
        this.stats = statsClientCapability;
    }

    public boolean testFreefall(EntityPlayer player) {
        double blockYmax;
        int zz;
        ZeroGravityEvent.InFreefall zeroGEvent = new ZeroGravityEvent.InFreefall((EntityLivingBase)player);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return false;
        }
        int playerFeetOnY = (int)(player.func_174813_aQ().field_72338_b - 0.01);
        int xx = MathHelper.func_76128_c((double)player.field_70165_t);
        BlockPos pos = new BlockPos(xx, playerFeetOnY, zz = MathHelper.func_76128_c((double)player.field_70161_v));
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b.func_149688_o(state) != Material.field_151579_a && !(b instanceof BlockLiquid) && player.func_174813_aQ().field_72338_b - (blockYmax = b == GCBlocks.platform ? (double)playerFeetOnY + 1.0 : (double)playerFeetOnY + b.func_185496_a((IBlockState)state, (IBlockAccess)player.field_70170_p, (BlockPos)pos).field_72337_e) < 0.01 && player.func_174813_aQ().field_72338_b - blockYmax > -0.5) {
            BlockPos offsetPos;
            AxisAlignedBB collisionBox;
            player.field_70122_E = true;
            if (player.func_174813_aQ().field_72338_b - blockYmax > 0.0) {
                player.field_70163_u -= player.func_174813_aQ().field_72338_b - blockYmax;
                player.func_174826_a(player.func_174813_aQ().func_72317_d(0.0, blockYmax - player.func_174813_aQ().field_72338_b, 0.0));
            } else if (b.func_176209_a(player.field_70170_p.func_180495_p(new BlockPos(xx, playerFeetOnY, zz)), false) && (collisionBox = b.func_180646_a(player.field_70170_p.func_180495_p(offsetPos = new BlockPos(xx, playerFeetOnY, zz)), (IBlockAccess)player.field_70170_p, offsetPos)) != null && collisionBox.func_72326_a(player.func_174813_aQ())) {
                player.field_70163_u -= player.func_174813_aQ().field_72338_b - blockYmax;
                player.func_174826_a(player.func_174813_aQ().func_72317_d(0.0, blockYmax - player.func_174813_aQ().field_72338_b, 0.0));
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean testFreefall(EntityPlayerSP p, boolean flag) {
        boolean checkBlockWithinReach;
        World world = p.field_70170_p;
        WorldProvider worldProvider = world.field_73011_w;
        if (!(worldProvider instanceof IZeroGDimension)) {
            return false;
        }
        ZeroGravityEvent.InFreefall zeroGEvent = new ZeroGravityEvent.InFreefall((EntityLivingBase)p);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return false;
        }
        if (this.pjumpticks > 0 || this.stats.isSsOnGroundLast() && p.field_71158_b.field_78901_c) {
            return false;
        }
        if (p.func_184187_bx() != null) {
            Entity e = p.func_184187_bx();
            if (e instanceof EntitySpaceshipBase) {
                return ((EntitySpaceshipBase)e).getLaunched();
            }
            if (e instanceof EntityLanderBase) {
                return false;
            }
        }
        if (!flag) {
            return false;
        }
        float rY = p.field_70177_z % 360.0f;
        double zreach = 0.0;
        double xreach = 0.0;
        if (rY < 80.0f || rY > 280.0f) {
            zreach = 0.2;
        }
        if (rY < 170.0f && rY > 10.0f) {
            xreach = 0.2;
        }
        if (rY < 260.0f && rY > 100.0f) {
            zreach = -0.2;
        }
        if (rY < 350.0f && rY > 190.0f) {
            xreach = -0.2;
        }
        AxisAlignedBB playerReach = p.func_174813_aQ().func_72321_a(xreach, 0.0, zreach);
        if (worldProvider instanceof WorldProviderSpaceStation) {
            SpinManager spinManager = ((WorldProviderSpaceStation)worldProvider).getSpinManager();
            checkBlockWithinReach = playerReach.field_72336_d >= (double)spinManager.ssBoundsMinX && playerReach.field_72340_a <= (double)spinManager.ssBoundsMaxX && playerReach.field_72337_e >= (double)spinManager.ssBoundsMinY && playerReach.field_72338_b <= (double)spinManager.ssBoundsMaxY && playerReach.field_72334_f >= (double)spinManager.ssBoundsMinZ && playerReach.field_72339_c <= (double)spinManager.ssBoundsMaxZ;
        } else {
            checkBlockWithinReach = true;
        }
        if (checkBlockWithinReach) {
            int xm = MathHelper.func_76128_c((double)playerReach.field_72340_a);
            int xx = MathHelper.func_76128_c((double)playerReach.field_72336_d);
            int ym = MathHelper.func_76128_c((double)playerReach.field_72338_b);
            int yy = MathHelper.func_76128_c((double)playerReach.field_72337_e);
            int zm = MathHelper.func_76128_c((double)playerReach.field_72339_c);
            int zz = MathHelper.func_76128_c((double)playerReach.field_72334_f);
            for (int x = xm; x <= xx; ++x) {
                for (int y = ym; y <= yy; ++y) {
                    for (int z = zm; z <= zz; ++z) {
                        Block b = world.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                        if (Blocks.field_150350_a == b || GCBlocks.brightAir == b) continue;
                        this.onWall = true;
                        return false;
                    }
                }
            }
        }
        this.onWall = false;
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void setupFreefallPre(EntityPlayerSP p) {
        double dY = p.field_70181_x - this.pPrevMotionY;
        this.jetpackBoost = 0.0f;
        this.pPrevdY = dY;
        this.pPrevMotionX = p.field_70159_w;
        this.pPrevMotionY = p.field_70181_x;
        this.pPrevMotionZ = p.field_70179_y;
    }

    @SideOnly(value=Side.CLIENT)
    public void freefallMotion(EntityPlayerSP p) {
        float speedLimit;
        boolean jetpackUsed = false;
        double dX = p.field_70159_w - this.pPrevMotionX;
        double dY = p.field_70181_x - this.pPrevMotionY;
        double dZ = p.field_70179_y - this.pPrevMotionZ;
        double posOffsetX = -p.field_70159_w;
        double posOffsetY = -p.field_70181_x;
        if (posOffsetY == -TransformerHooks.getGravityForEntity((Entity)p)) {
            posOffsetY = 0.0;
        }
        double posOffsetZ = -p.field_70179_y;
        GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)p);
        if (dY < 0.0 && p.field_70181_x != 0.0) {
            p.field_70181_x = this.pPrevMotionY;
        } else if (dY > 0.01 && stats.isInFreefallLast()) {
            if (dX < 0.01 && dZ < 0.01) {
                float pitch = p.field_70125_A / 57.295776f;
                this.jetpackBoost = (float)dY * MathHelper.func_76134_b((float)pitch) * 0.1f;
                float factor = 1.0f + MathHelper.func_76126_a((float)pitch) / 5.0f;
                p.field_70181_x -= dY * (double)factor;
                jetpackUsed = true;
            } else {
                p.field_70181_x -= dY / 2.0;
            }
        }
        p.field_70159_w -= dX;
        p.field_70179_y -= dZ;
        if (p.field_71158_b.field_192832_b != 0.0f) {
            p.field_70159_w = p.field_70159_w - (double)(p.field_71158_b.field_192832_b * MathHelper.func_76126_a((float)(p.field_70177_z / 57.295776f)) / (ConfigManagerCore.hardMode ? 600.0f : 200.0f));
            p.field_70179_y = p.field_70179_y + (double)(p.field_71158_b.field_192832_b * MathHelper.func_76134_b((float)(p.field_70177_z / 57.295776f)) / (ConfigManagerCore.hardMode ? 600.0f : 200.0f));
        }
        if (this.jetpackBoost != 0.0f) {
            p.field_70159_w -= (double)(this.jetpackBoost * MathHelper.func_76126_a((float)(p.field_70177_z / 57.295776f)));
            p.field_70179_y += (double)(this.jetpackBoost * MathHelper.func_76134_b((float)(p.field_70177_z / 57.295776f)));
        }
        if (p.field_71158_b.field_78899_d) {
            if (!this.sneakLast) {
                this.sneakLast = true;
            }
            p.field_70181_x = p.field_70181_x - (ConfigManagerCore.hardMode ? 0.002 : 0.0032);
        } else if (this.sneakLast) {
            this.sneakLast = false;
        }
        if (!jetpackUsed && p.field_71158_b.field_78901_c) {
            p.field_70181_x = p.field_70181_x + (ConfigManagerCore.hardMode ? 0.002 : 0.0032);
        }
        float f = speedLimit = ConfigManagerCore.hardMode ? 0.9f : 0.7f;
        if (p.field_70159_w > (double)speedLimit) {
            p.field_70159_w = speedLimit;
        }
        if (p.field_70159_w < (double)(-speedLimit)) {
            p.field_70159_w = -speedLimit;
        }
        if (p.field_70181_x > (double)speedLimit) {
            p.field_70181_x = speedLimit;
        }
        if (p.field_70181_x < (double)(-speedLimit)) {
            p.field_70181_x = -speedLimit;
        }
        if (p.field_70179_y > (double)speedLimit) {
            p.field_70179_y = speedLimit;
        }
        if (p.field_70179_y < (double)(-speedLimit)) {
            p.field_70179_y = -speedLimit;
        }
        this.pPrevMotionX = p.field_70159_w;
        this.pPrevMotionY = p.field_70181_x;
        this.pPrevMotionZ = p.field_70179_y;
        p.func_70091_d(MoverType.SELF, p.field_70159_w + posOffsetX, p.field_70181_x + posOffsetY, p.field_70179_y + posOffsetZ);
    }

    public void updateFreefall(EntityPlayer p) {
        this.pPrevMotionX = p.field_70159_w;
        this.pPrevMotionY = p.field_70181_x;
        this.pPrevMotionZ = p.field_70179_y;
    }

    @SideOnly(value=Side.CLIENT)
    public void preVanillaMotion(EntityPlayerSP p) {
        this.setupFreefallPre(p);
        this.stats.setSsOnGroundLast(p.field_70122_E);
    }

    @SideOnly(value=Side.CLIENT)
    public void postVanillaMotion(EntityPlayerSP p) {
        boolean doCentrifugal;
        World world = p.field_70170_p;
        WorldProvider worldProvider = world.field_73011_w;
        if (!(worldProvider instanceof IZeroGDimension)) {
            return;
        }
        ZeroGravityEvent.Motion zeroGEvent = new ZeroGravityEvent.Motion((EntityLivingBase)p);
        MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
        if (zeroGEvent.isCanceled()) {
            return;
        }
        boolean freefall = this.stats.isInFreefall();
        freefall = this.testFreefall(p, freefall);
        this.stats.setInFreefall(freefall);
        this.stats.setInFreefallFirstCheck(true);
        SpinManager spinManager = null;
        if (worldProvider instanceof WorldProviderSpaceStation && !this.stats.getPlatformControlled()) {
            spinManager = ((WorldProviderSpaceStation)worldProvider).getSpinManager();
        }
        boolean bl = doCentrifugal = spinManager != null;
        if (freefall) {
            this.pjumpticks = 0;
            p.field_70159_w /= (double)0.91f;
            p.field_70179_y /= (double)0.91f;
            p.field_70181_x /= (double)0.98f;
            if (spinManager != null) {
                doCentrifugal = spinManager.updatePlayerForSpin(p, 1.0f);
            }
            if (!p.field_71075_bZ.field_75098_d) {
                this.freefallMotion(p);
            } else {
                p.field_71075_bZ.field_75100_b = true;
                double dx = p.field_70159_w - this.pPrevMotionX;
                double dy = p.field_70181_x - this.pPrevMotionY;
                double dz = p.field_70179_y - this.pPrevMotionZ;
                p.field_70159_w -= dx / 2.0;
                p.field_70181_x -= dy / 2.0;
                p.field_70179_y -= dz / 2.0;
                if (p.field_70159_w > (double)1.2f) {
                    p.field_70159_w = 1.2f;
                }
                if (p.field_70159_w < (double)-1.2f) {
                    p.field_70159_w = -1.2f;
                }
                if (p.field_70181_x > (double)0.7f) {
                    p.field_70181_x = 0.7f;
                }
                if (p.field_70181_x < (double)-0.7f) {
                    p.field_70181_x = -0.7f;
                }
                if (p.field_70179_y > (double)1.2f) {
                    p.field_70179_y = 1.2f;
                }
                if (p.field_70179_y < (double)-1.2f) {
                    p.field_70179_y = -1.2f;
                }
            }
        } else {
            double dy = p.field_70181_x - this.pPrevMotionY;
            if (p.field_71158_b.field_78901_c) {
                if ((p.field_70122_E || this.stats.isSsOnGroundLast()) && !p.field_71075_bZ.field_75098_d) {
                    if (this.pjumpticks < 25) {
                        ++this.pjumpticks;
                    }
                    p.field_70181_x -= dy;
                } else {
                    p.field_70181_x += 0.015;
                    if (this.pjumpticks == 0) {
                        p.field_70181_x -= dy;
                    }
                }
            } else if (this.pjumpticks > 0) {
                p.field_70181_x += 0.0145 * (double)this.pjumpticks;
                this.pjumpticks = 0;
            } else if (p.field_71158_b.field_78899_d) {
                if (!p.field_70122_E) {
                    p.field_70181_x -= 0.015;
                }
                this.pjumpticks = 0;
            }
        }
        if (doCentrifugal && !p.field_70122_E) {
            spinManager.applyCentrifugalForce(p);
        }
        this.pPrevMotionX = p.field_70159_w;
        this.pPrevMotionY = p.field_70181_x;
        this.pPrevMotionZ = p.field_70179_y;
    }

    public static boolean testEntityFreefall(World worldObj, AxisAlignedBB entityBoundingBox) {
        int xmx = MathHelper.func_76128_c((double)(entityBoundingBox.field_72336_d + 0.2));
        int ym = MathHelper.func_76128_c((double)(entityBoundingBox.field_72338_b - 0.1));
        int yy = MathHelper.func_76128_c((double)(entityBoundingBox.field_72337_e + 0.1));
        int zm = MathHelper.func_76128_c((double)(entityBoundingBox.field_72339_c - 0.2));
        int zz = MathHelper.func_76128_c((double)(entityBoundingBox.field_72334_f + 0.2));
        if (ym < 0) {
            ym = 0;
        }
        if (yy > 255) {
            yy = 255;
        }
        for (int x = MathHelper.func_76128_c((double)(entityBoundingBox.field_72340_a - 0.2)); x <= xmx; ++x) {
            for (int z = zm; z <= zz; ++z) {
                if (!worldObj.func_175668_a(new BlockPos(x, 0, z), false)) continue;
                for (int y = ym; y <= yy; ++y) {
                    if (Blocks.field_150350_a == worldObj.func_180495_p(new BlockPos(x, y, z)).func_177230_c()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void tickFreefallEntity(Entity e) {
        if (e.field_70170_p.field_73011_w instanceof IZeroGDimension) {
            ((IZeroGDimension)e.field_70170_p.field_73011_w).setInFreefall(e);
        }
        boolean warnLog = false;
        if (e instanceof EntityLivingBase) {
            ZeroGravityEvent.InFreefall zeroGEvent = new ZeroGravityEvent.InFreefall((EntityLivingBase)e);
            MinecraftForge.EVENT_BUS.post((Event)zeroGEvent);
            if (!zeroGEvent.isCanceled()) {
                e.field_70159_w /= (double)0.91f;
                e.field_70179_y /= (double)0.91f;
                e.field_70181_x = e.field_70181_x / (e instanceof EntityFlying ? (double)0.91f : (double)0.98f);
                if (e.field_70159_w > 10.0) {
                    warnLog = true;
                    e.field_70159_w = 10.0;
                } else if (e.field_70159_w < -10.0) {
                    warnLog = true;
                    e.field_70159_w = -10.0;
                }
                if (e.field_70181_x > 10.0) {
                    warnLog = true;
                    e.field_70181_x = 10.0;
                } else if (e.field_70181_x < -10.0) {
                    warnLog = true;
                    e.field_70181_x = -10.0;
                }
                if (e.field_70179_y > 10.0) {
                    warnLog = true;
                    e.field_70179_y = 10.0;
                } else if (e.field_70179_y < -10.0) {
                    warnLog = true;
                    e.field_70179_y = -10.0;
                }
            }
        } else if (e instanceof EntityFallingBlock) {
            e.field_70181_x /= (double)0.98f;
            if (e.field_70181_x > 10.0) {
                warnLog = true;
                e.field_70181_x = 10.0;
            } else if (e.field_70181_x < -10.0) {
                warnLog = true;
                e.field_70181_x = -10.0;
            }
        } else {
            e.field_70159_w /= (double)0.98f;
            e.field_70181_x /= (double)0.98f;
            e.field_70179_y /= (double)0.98f;
            if (e.field_70159_w > 10.0) {
                warnLog = true;
                e.field_70159_w = 10.0;
            } else if (e.field_70159_w < -10.0) {
                warnLog = true;
                e.field_70159_w = -10.0;
            }
            if (e.field_70181_x > 10.0) {
                warnLog = true;
                e.field_70181_x = 10.0;
            } else if (e.field_70181_x < -10.0) {
                warnLog = true;
                e.field_70181_x = -10.0;
            }
            if (e.field_70179_y > 10.0) {
                warnLog = true;
                e.field_70179_y = 10.0;
            } else if (e.field_70179_y < -10.0) {
                warnLog = true;
                e.field_70179_y = -10.0;
            }
        }
        if (warnLog) {
            GalacticraftCore.logger.debug(e.func_70005_c_() + " moving too fast", new Object[0]);
        }
    }
}

