/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.pipes;

import buildcraft.additionalpipes.api.ITeleportPipe;
import buildcraft.additionalpipes.api.TeleportPipeType;
import buildcraft.additionalpipes.pipes.PipeBehaviorTeleport;
import buildcraft.additionalpipes.pipes.TeleportManager;
import buildcraft.additionalpipes.utils.Log;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeEventFluid;
import buildcraft.api.transport.pipe.PipeEventHandler;
import buildcraft.transport.pipe.flow.PipeFlowFluids;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class PipeBehaviorTeleportFluids
extends PipeBehaviorTeleport {
    public PipeBehaviorTeleportFluids(IPipe pipe, NBTTagCompound tagCompound) {
        super(pipe, tagCompound, TeleportPipeType.FLUIDS);
    }

    public PipeBehaviorTeleportFluids(IPipe pipe) {
        super(pipe, TeleportPipeType.FLUIDS);
    }

    @PipeEventHandler
    public void preMoveCenter(PipeEventFluid.PreMoveToCentre event) {
        if (this.canSend()) {
            ArrayList<ITeleportPipe> connectedPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
            int totalMBNeeded = 0;
            for (PipeBehaviorTeleportFluids pipeBehaviorTeleportFluids : connectedPipes) {
                totalMBNeeded += pipeBehaviorTeleportFluids.getMaxAcceptableMB(event.fluid.getFluid());
            }
            Log.debug("[FluidTeleportPipe] Requested " + totalMBNeeded + " MB of fluid");
            for (EnumFacing side : EnumFacing.field_82609_l) {
                int fluidFromThisSide;
                event.actuallyOffered[side.ordinal()] = fluidFromThisSide = Math.min(event.totalOffered[side.ordinal()], totalMBNeeded);
                totalMBNeeded -= fluidFromThisSide;
            }
        }
    }

    @PipeEventHandler
    public void onMoveCenter(PipeEventFluid.OnMoveToCentre event) {
        if (this.canSend()) {
            ArrayList<ITeleportPipe> connectedPipes = TeleportManager.instance.getConnectedPipes(this, false, true);
            Log.debug("[FluidTeleportPipe] Got " + event.fluid.amount + " MB of fluid");
            FluidStack remaining = event.fluid.copy();
            while (remaining.amount > 0 && connectedPipes.size() > 0) {
                FluidStack maxPerIteration = remaining.copy();
                maxPerIteration.amount /= connectedPipes.size();
                Iterator<ITeleportPipe> pipeIter = connectedPipes.iterator();
                while (pipeIter.hasNext()) {
                    PipeBehaviorTeleportFluids pipe = (PipeBehaviorTeleportFluids)pipeIter.next();
                    int inserted = ((PipeFlowFluids)pipe.pipe.getFlow()).insertFluidsForce(maxPerIteration, null, false);
                    if (inserted == 0) {
                        pipeIter.remove();
                        continue;
                    }
                    remaining.amount -= inserted;
                }
            }
            if (remaining.amount > 0) {
                Log.debug("PipeLiquidsTeleport's PreMoveToCentre event handler requested more fluid than can be handled!  " + remaining.amount + " MB is left and will be rejected.");
            }
            for (EnumFacing side : EnumFacing.field_82609_l) {
                event.fluidEnteringCentre[side.ordinal()] = 0;
                if (remaining.amount <= 0) continue;
                int fluidBlockedFromEntering = Math.min(event.fluidLeavingSide[side.ordinal()], remaining.amount);
                int n = side.ordinal();
                event.fluidLeavingSide[n] = event.fluidLeavingSide[n] - fluidBlockedFromEntering;
                remaining.amount -= fluidBlockedFromEntering;
            }
        }
    }

    public int getMaxAcceptableMB(Fluid fluid) {
        return ((PipeFlowFluids)this.pipe.getFlow()).insertFluidsForce(new FluidStack(fluid, Integer.MAX_VALUE), null, true);
    }
}

