/*
 * Decompiled with CFR 0.152.
 */
package mod.icarus.balkonsexpansion.item;

import ckathode.weaponmod.WeaponModAttributes;
import ckathode.weaponmod.item.IExtendedReachItem;
import ckathode.weaponmod.item.IItemWeapon;
import ckathode.weaponmod.item.MeleeCompHalberd;
import com.google.common.collect.Multimap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MeleeCompHalberdCustom
extends MeleeCompHalberd
implements IExtendedReachItem {
    private float knockbackAmount;
    private float reachAmount;

    public MeleeCompHalberdCustom(Item.ToolMaterial material, float knockbackAmount, float reachAmount) {
        super(material);
        this.knockbackAmount = knockbackAmount;
        this.reachAmount = reachAmount;
    }

    public float getKnockBack(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        float kb = this.knockbackAmount + 0.4f;
        return MeleeCompHalberdCustom.getHalberdState((ItemStack)itemstack) ? kb / 2.0f : kb;
    }

    public void addItemAttributeModifiers(Multimap<String, AttributeModifier> multimap) {
        float dmg = this.getEntityDamage();
        if (dmg > 0.0f || this.meleeSpecs.damageMult > 0.0f) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.ATTACK_DAMAGE_MODIFIER, "Weapon attack damage modifier", (double)dmg, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.ATTACK_SPEED_MODIFIER, "Weapon attack speed modifier", (double)(-this.meleeSpecs.attackDelay), 0));
        }
        if (this.knockbackAmount != 0.0f) {
            multimap.put((Object)WeaponModAttributes.WEAPON_KNOCKBACK.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.KNOCKBACK_MODIFIER, "Weapon knockback modifier", (double)this.knockbackAmount, 0));
        }
        if (this instanceof IExtendedReachItem) {
            try {
                multimap.put((Object)WeaponModAttributes.WEAPON_REACH.func_111108_a(), (Object)new AttributeModifier(IItemWeapon.REACH_MODIFIER, "Weapon reach modifier", (double)(this.getExtendedReach(null, null, null) - 3.0f), 0));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public float getExtendedReach(World world, EntityLivingBase living, ItemStack itemstack) {
        return this.reachAmount + 3.0f;
    }
}

