/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.helpers;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import veovismuaddib.mystcraft_info.ModConfig;

public class PoemHelper {
    public static List<String> allWords = Arrays.asList("Balance", "Believe", "Celestial", "Chain", "Change", "Chaos", "Civilization", "Constraint", "Contradict", "Control", "Convey", "Creativity", "Cycle", "Dependence", "Discover", "Dynamic", "Elevate", "Encourage", "Energy", "Entropy", "Ethereal", "Exist", "Explore", "Flow", "Force", "Form", "Future", "Growth", "Harmony", "Honor", "Image", "Infinite", "Inhibit", "Intelligence", "Love", "Machine", "Merge", "Momentum", "Motion", "Mutual", "Nature", "Nurture", "Order", "Possibility", "Power", "Question", "Rebirth", "Remember", "Resilience", "Resurrect", "Sacrifice", "Society", "Spur", "Static", "Stimulate", "Survival", "Sustain", "System", "Terrain", "Time", "Tradition", "Transform", "Void", "Weave", "Wisdom");
    private static final HashMap<ResourceLocation, List<String>> poemCache = new HashMap();

    public static List<String> getPoemFromSymbol(IAgeSymbol symbol) {
        if (symbol == null) {
            return null;
        }
        ResourceLocation location = symbol.getRegistryName();
        if (poemCache.containsKey(location)) {
            return poemCache.get(location);
        }
        ArrayList<String> poem = new ArrayList<String>();
        String replacement = null;
        boolean replaceWithName = ModConfig.poems.replace_with_name;
        boolean replaceWithQuestionMarks = ModConfig.poems.replace_with_question_marks;
        if (replaceWithQuestionMarks || replaceWithName) {
            replacement = replaceWithName ? symbol.getLocalizedName() : "???";
        }
        for (String word : symbol.getPoem()) {
            if (replacement == null || allWords.contains(word)) {
                poem.add(word);
                continue;
            }
            poem.add(replacement);
        }
        poemCache.put(location, poem);
        return poem;
    }
}

