/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.List;
import veovismuaddib.mystcraft_info.ModConfig;
import veovismuaddib.mystcraft_info.helpers.ModifierHelper;
import veovismuaddib.mystcraft_info.info.SymbolTooltip;

public class DirectionTooltip
extends SymbolTooltip.SymbolTooltipGroup {
    public DirectionTooltip() {
        super.setHeader("gui.mystcraft_info.direction.header");
        super.add(new PercentDirectionTooltip());
        super.add(new DegreeDirectionTooltip());
    }

    @Override
    public List<String> getTooltip(IAgeSymbol symbol) {
        List<String> tooltip = super.getTooltip(symbol);
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        Number direction = ModifierHelper.getDirectionFromSymbol(symbol);
        if (direction == null) {
            return tooltip;
        }
        return tooltip;
    }

    private static class DegreeDirectionTooltip
    extends SymbolTooltip {
        private DegreeDirectionTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.direction_degrees.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.direction_degrees.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number direction = ModifierHelper.getDirectionFromSymbol(symbol);
            return direction != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number direction = ModifierHelper.getDirectionFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (direction == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + String.format("%.1f\u00c2\u00b0", Float.valueOf(direction.floatValue())));
            return tooltip;
        }
    }

    private static class PercentDirectionTooltip
    extends SymbolTooltip {
        private PercentDirectionTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.direction_percent.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.direction_percent.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number direction = ModifierHelper.getDirectionFromSymbol(symbol);
            return direction != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number direction = ModifierHelper.getDirectionFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (direction == null) {
                return tooltip;
            }
            float percentageDirection = direction.floatValue() / 360.0f % 1.0f;
            tooltip.add(this.DEFAULT_FORMAT + String.format("%d%%", Math.round(percentageDirection * 100.0f)));
            return tooltip;
        }
    }
}

