/*
 * Decompiled with CFR 0.152.
 */
package veovismuaddib.mystcraft_info.info;

import com.xcompwiz.mystcraft.api.symbol.IAgeSymbol;
import java.util.ArrayList;
import java.util.List;
import veovismuaddib.mystcraft_info.ModConfig;
import veovismuaddib.mystcraft_info.helpers.ModifierHelper;
import veovismuaddib.mystcraft_info.info.SymbolTooltip;

public class LengthTooltip
extends SymbolTooltip.SymbolTooltipGroup {
    public LengthTooltip() {
        super.setHeader("gui.mystcraft_info.length.header");
        super.add(new PercentLengthTooltip());
        super.add(new DecimalLengthTooltip());
    }

    @Override
    public List<String> getTooltip(IAgeSymbol symbol) {
        List<String> tooltip = super.getTooltip(symbol);
        if (!this.isVisible(symbol)) {
            return tooltip;
        }
        Number length = ModifierHelper.getLengthFromSymbol(symbol);
        if (length == null) {
            return tooltip;
        }
        return tooltip;
    }

    private static class DecimalLengthTooltip
    extends SymbolTooltip {
        private DecimalLengthTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.length_decimal.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.length_decimal.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number length = ModifierHelper.getLengthFromSymbol(symbol);
            return length != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number length = ModifierHelper.getLengthFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (length == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + String.format("%.1f", Float.valueOf(length.floatValue())));
            return tooltip;
        }
    }

    private static class PercentLengthTooltip
    extends SymbolTooltip {
        private PercentLengthTooltip() {
        }

        @Override
        public boolean isEnabled() {
            return ModConfig.tooltips.length_percent.enabled;
        }

        @Override
        public boolean requiresShift() {
            return ModConfig.tooltips.length_percent.shift_required;
        }

        @Override
        public boolean isRelevant(IAgeSymbol symbol) {
            Number length = ModifierHelper.getLengthFromSymbol(symbol);
            return length != null;
        }

        @Override
        public List<String> getTooltip(IAgeSymbol symbol) {
            ArrayList<String> tooltip = new ArrayList<String>();
            Number length = ModifierHelper.getLengthFromSymbol(symbol);
            if (!this.isVisible(symbol)) {
                return tooltip;
            }
            if (length == null) {
                return tooltip;
            }
            tooltip.add(this.DEFAULT_FORMAT + String.format("%d%%", Math.round(length.floatValue() * 100.0f)));
            return tooltip;
        }
    }
}

