/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.renderer.chunk;

import java.nio.ByteBuffer;
import meldexun.memoryutil.MemoryAccess;
import meldexun.memoryutil.UnsafeByteBuffer;
import meldexun.nothirium.api.renderer.IVBOPart;
import meldexun.nothirium.api.renderer.chunk.IChunkRenderer;
import meldexun.nothirium.api.renderer.chunk.IRenderChunkDispatcher;
import meldexun.nothirium.api.renderer.chunk.RenderChunkTaskResult;
import meldexun.nothirium.mc.renderer.chunk.RenderChunk;
import meldexun.nothirium.renderer.chunk.AbstractRenderChunkTask;
import meldexun.nothirium.util.VertexSortUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL15;

public class RenderChunkTaskSortTranslucent
extends AbstractRenderChunkTask<RenderChunk> {
    private final IVBOPart vboPart;
    private final UnsafeByteBuffer vertexData;

    public RenderChunkTaskSortTranslucent(IChunkRenderer<?> chunkRenderer, IRenderChunkDispatcher taskDispatcher, RenderChunk renderChunk, IVBOPart vboPart, UnsafeByteBuffer vertexData) {
        super(chunkRenderer, taskDispatcher, renderChunk);
        this.vboPart = vboPart;
        this.vertexData = vertexData;
    }

    @Override
    public RenderChunkTaskResult run() {
        if (this.canceled()) {
            return RenderChunkTaskResult.CANCELLED;
        }
        if (!this.vboPart.isValid()) {
            return RenderChunkTaskResult.CANCELLED;
        }
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            return RenderChunkTaskResult.CANCELLED;
        }
        Vec3d camera = entity.func_174824_e(1.0f);
        VertexSortUtil.sortVertexData((MemoryAccess)this.vertexData, this.vboPart.getCount(), DefaultVertexFormats.field_176600_a.func_177338_f(), 4, (float)((double)((RenderChunk)this.renderChunk).getX() - camera.field_72450_a), (float)((double)((RenderChunk)this.renderChunk).getY() - camera.field_72448_b), (float)((double)((RenderChunk)this.renderChunk).getZ() - camera.field_72449_c));
        this.taskDispatcher.runOnRenderThread(() -> {
            if (!this.canceled() && this.vboPart.isValid()) {
                GL15.glBindBuffer((int)34962, (int)this.vboPart.getVBO());
                GL15.glBufferSubData((int)34962, (long)(this.vboPart.getFirst() * DefaultVertexFormats.field_176600_a.func_177338_f()), (ByteBuffer)((ByteBuffer)this.vertexData.getBuffer()));
                GL15.glBindBuffer((int)34962, (int)0);
            }
        });
        return RenderChunkTaskResult.SUCCESSFUL;
    }
}

