/*
 * Decompiled with CFR 0.152.
 */
package meldexun.nothirium.mc.vertex;

import meldexun.memoryutil.UnsafeUtil;
import meldexun.nothirium.mc.vertex.ExtendedBufferBuilder;
import meldexun.nothirium.mc.vertex.VertexConsumer;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import sun.misc.Unsafe;

public class TextureCoordinateUploader {
    private static final VertexConsumer FLOAT = new VertexConsumer(){

        @Override
        public void tex(ExtendedBufferBuilder buffer, double u, double v) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, (float)u);
            unsafe.putFloat(address + 4L, (float)v);
        }

        @Override
        public void lightmap(ExtendedBufferBuilder buffer, int skyLight, int blockLight) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putFloat(address, skyLight);
            unsafe.putFloat(address + 4L, blockLight);
        }
    };
    private static final VertexConsumer INT = new VertexConsumer(){

        @Override
        public void tex(ExtendedBufferBuilder buffer, double u, double v) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putInt(address, (int)u);
            unsafe.putInt(address + 4L, (int)v);
        }

        @Override
        public void lightmap(ExtendedBufferBuilder buffer, int skyLight, int blockLight) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putInt(address, skyLight);
            unsafe.putInt(address + 4L, blockLight);
        }
    };
    private static final VertexConsumer SHORT = new VertexConsumer(){

        @Override
        public void tex(ExtendedBufferBuilder buffer, double u, double v) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putShort(address, (short)v);
            unsafe.putShort(address + 2L, (short)u);
        }

        @Override
        public void lightmap(ExtendedBufferBuilder buffer, int skyLight, int blockLight) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putShort(address, (short)blockLight);
            unsafe.putShort(address + 2L, (short)skyLight);
        }
    };
    private static final VertexConsumer BYTE = new VertexConsumer(){

        @Override
        public void tex(ExtendedBufferBuilder buffer, double u, double v) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)v);
            unsafe.putByte(address + 1L, (byte)u);
        }

        @Override
        public void lightmap(ExtendedBufferBuilder buffer, int skyLight, int blockLight) {
            Unsafe unsafe = UnsafeUtil.UNSAFE;
            long address = buffer.getAddress() + (long)buffer.getOffset();
            unsafe.putByte(address, (byte)blockLight);
            unsafe.putByte(address + 1L, (byte)skyLight);
        }
    };

    public static VertexConsumer fromType(VertexFormatElement.EnumType type) {
        switch (type) {
            case FLOAT: {
                return FLOAT;
            }
            case UINT: 
            case INT: {
                return INT;
            }
            case USHORT: 
            case SHORT: {
                return SHORT;
            }
            case UBYTE: 
            case BYTE: {
                return BYTE;
            }
        }
        return null;
    }
}

