/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.crossmod;

import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.factory.tile.TileTank;
import buildcraft.lib.fluid.TankManager;
import buildcraft.lib.tile.TileBC_Neptune;
import buildcraft.transport.pipe.Pipe;
import buildcraft.transport.pipe.flow.PipeFlowFluids;
import buildcraft.transport.tile.TilePipeHolder;
import com.zuxelus.energycontrol.crossmod.CrossModBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class CrossBuildCraft
extends CrossModBase {
    @Override
    public List<FluidInfo> getAllTanks(TileEntity te) {
        try {
            IFluidHandler fluid;
            if (te instanceof TilePipeHolder) {
                Pipe pipe = ((TilePipeHolder)te).getPipe();
                if (pipe == null) {
                    return null;
                }
                PipeFlow flow = pipe.getFlow();
                if (flow instanceof PipeFlowFluids) {
                    Field field = PipeFlowFluids.class.getDeclaredField("currentFluid");
                    field.setAccessible(true);
                    FluidStack stack = (FluidStack)field.get(flow);
                    if (stack == null) {
                        ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
                        result.add(new FluidInfo(stack, ((PipeFlowFluids)flow).capacity));
                        return result;
                    }
                    int amount = 0;
                    for (EnumFacing side : EnumFacing.field_82609_l) {
                        FluidStack currStack = ((PipeFlowFluids)flow).extractFluidsForce(0, 100000, side, true);
                        amount += currStack.amount;
                    }
                    ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
                    result.add(new FluidInfo(stack.getFluid(), stack.getLocalizedName(), (long)amount, (long)((PipeFlowFluids)flow).capacity));
                    return result;
                }
            }
            if (te instanceof TileTank && (fluid = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) != null) {
                IFluidTankProperties[] tanks = fluid.getTankProperties();
                ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
                for (IFluidTankProperties tank : tanks) {
                    result.add(new FluidInfo(tank.getContents(), tank.getCapacity()));
                }
                return result;
            }
            if (te instanceof TileBC_Neptune) {
                Field field = TileBC_Neptune.class.getDeclaredField("tankManager");
                field.setAccessible(true);
                TankManager tankManager = (TankManager)field.get(te);
                IFluidTankProperties[] tanks = tankManager.getTankProperties();
                if (tanks.length > 0) {
                    ArrayList<FluidInfo> result = new ArrayList<FluidInfo>();
                    for (IFluidTankProperties tank : tanks) {
                        result.add(new FluidInfo(tank.getContents(), tank.getCapacity()));
                    }
                    return result;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

