/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import com.zuxelus.energycontrol.utils.FluidInfo;
import com.zuxelus.energycontrol.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardLiquidArray
extends ItemCardBase {
    private static final long STATUS_NOT_FOUND = Integer.MIN_VALUE;
    private static final long STATUS_OUT_OF_RANGE = -2147483647L;

    public ItemCardLiquidArray() {
        super(11, "card_liquid_array");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        int cardCount = reader.getCardCount();
        if (cardCount == 0) {
            return CardState.INVALID_CARD;
        }
        double totalAmount = 0.0;
        boolean foundAny = false;
        boolean outOfRange = false;
        for (int i = 0; i < cardCount; ++i) {
            BlockPos target = this.getCoordinates(reader, i);
            int dx = target.func_177958_n() - pos.func_177958_n();
            int dy = target.func_177956_o() - pos.func_177956_o();
            int dz = target.func_177952_p() - pos.func_177952_p();
            if (Math.abs(dx) <= range && Math.abs(dy) <= range && Math.abs(dz) <= range) {
                FluidInfo storage = CrossModLoader.getTankAt(world, target);
                if (storage != null) {
                    storage.write(reader, i);
                    foundAny = true;
                    continue;
                }
                reader.setLong(String.format("_%damount", i), (Long)Integer.MIN_VALUE);
                continue;
            }
            reader.setLong(String.format("_%damount", i), -2147483647L);
            outOfRange = true;
        }
        reader.setDouble("energy", totalAmount);
        if (!foundAny) {
            if (outOfRange) {
                return CardState.OUT_OF_RANGE;
            }
            return CardState.NO_TARGET;
        }
        return CardState.OK;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        List<PanelString> result = reader.getTitleList();
        double totalAmount = 0.0;
        double totalCapacity = 0.0;
        boolean showName = (settings & 1) > 0;
        boolean showAmount = true;
        boolean showFree = (settings & 2) > 0;
        boolean showCapacity = (settings & 4) > 0;
        boolean showPercentage = (settings & 8) > 0;
        boolean showEach = (settings & 0x10) > 0;
        boolean showSummary = (settings & 0x20) > 0;
        for (int i = 0; i < reader.getInt("cardCount"); ++i) {
            boolean isNotFound;
            long amount = reader.getLong(String.format("_%damount", i));
            long capacity = reader.getLong(String.format("_%dcapacity", i));
            boolean isOutOfRange = amount == -2147483647L;
            boolean bl = isNotFound = amount == Integer.MIN_VALUE;
            if (showSummary && !isOutOfRange && !isNotFound) {
                totalAmount += (double)amount;
                totalCapacity += (double)capacity;
            }
            if (!showEach) continue;
            if (isOutOfRange) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelOutOfRangeN", i + 1)));
                continue;
            }
            if (isNotFound) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelNotFoundN", i + 1)));
                continue;
            }
            if (showName) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelLiquidNameN", i + 1, reader.getString(String.format("_%dname", i)))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", amount, false)));
                }
            }
            if (showAmount) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelLiquidN", i + 1, StringUtils.getFormatted("", amount, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", amount, false)));
                }
            }
            if (showFree) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelLiquidFreeN", i + 1, StringUtils.getFormatted("", capacity - amount, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", capacity - amount, false)));
                }
            }
            if (showCapacity) {
                if (showLabels) {
                    result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelLiquidCapacityN", i + 1, StringUtils.getFormatted("", capacity, false))));
                } else {
                    result.add(new PanelString(StringUtils.getFormatted("", capacity, false)));
                }
            }
            if (!showPercentage) continue;
            if (showLabels) {
                result.add(new PanelString(StringUtils.getFormattedKey("msg.ec.InfoPanelLiquidPercentageN", i + 1, StringUtils.getFormatted("", capacity == 0L ? 100.0 : (double)amount / (double)capacity * 100.0, false))));
                continue;
            }
            result.add(new PanelString(StringUtils.getFormatted("", capacity == 0L ? 100.0 : (double)amount / (double)capacity * 100.0, false)));
        }
        if (showSummary) {
            if (showAmount) {
                result.add(new PanelString("msg.ec.InfoPanelAmount", totalAmount, showLabels));
            }
            if (showFree) {
                result.add(new PanelString("msg.ec.InfoPanelFree", totalCapacity - totalAmount, showLabels));
            }
            if (showName) {
                result.add(new PanelString("msg.ec.InfoPanelCapacity", totalCapacity, showLabels));
            }
            if (showPercentage) {
                result.add(new PanelString("msg.ec.InfoPanelPercentage", totalCapacity == 0.0 ? 100.0 : totalAmount / totalCapacity * 100.0, showLabels));
            }
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>(6);
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidName", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidFree", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidCapacity", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelLiquidPercentage", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelEachCard", (Object[])new Object[0]), 16));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelTotal", (Object[])new Object[0]), 32));
        return result;
    }

    @Override
    public boolean isRemoteCard(ItemStack stack) {
        return false;
    }
}

