/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import com.zuxelus.energycontrol.blocks.TimerBlock;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityFacing;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTimer
extends TileEntityFacing
implements ITickable,
ITilePacketHandler {
    private int time = 0;
    private int startingTime;
    private boolean invertRedstone = false;
    private boolean isTicks = false;
    private boolean isWorking = false;
    private boolean sendSignal;
    private boolean isPowered;

    public int getTime() {
        return this.time;
    }

    public String getTimeString() {
        if (this.isTicks) {
            return Integer.toString(this.time);
        }
        int seconds = this.time / 20;
        return String.format("%02d:%02d:%02d", seconds / 3600, seconds % 3600 / 60, seconds % 60);
    }

    public void setTime(int value) {
        int old = this.time;
        this.time = value;
        if (!this.field_145850_b.field_72995_K && this.time != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getInvertRedstone() {
        return this.invertRedstone;
    }

    public void setInvertRedstone(boolean value) {
        boolean old = this.invertRedstone;
        this.invertRedstone = value;
        if (!this.field_145850_b.field_72995_K && this.invertRedstone != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getIsWorking() {
        return this.isWorking;
    }

    public void setIsWorking(boolean value) {
        boolean old = this.isWorking;
        this.isWorking = value;
        if (this.isWorking) {
            this.startingTime = this.time;
        }
        if (!this.field_145850_b.field_72995_K && this.isWorking != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getIsTicks() {
        return this.isTicks;
    }

    public void setIsTicks(boolean value) {
        boolean old = this.isTicks;
        this.isTicks = value;
        if (!this.field_145850_b.field_72995_K && this.isTicks != old) {
            this.notifyBlockUpdate();
        }
    }

    public boolean getPowered() {
        return this.sendSignal;
    }

    public void onNeighborChange() {
        boolean newPowered;
        boolean bl = newPowered = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(this.rotation), this.rotation) > 0;
        if (newPowered != this.isPowered) {
            if (!this.isPowered && newPowered) {
                this.time = this.startingTime;
                this.setIsWorking(true);
            }
            this.isPowered = newPowered;
        }
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.setTime(tag.func_74762_e("value"));
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.setInvertRedstone(tag.func_74762_e("value") == 1);
                break;
            }
            case 3: {
                if (!tag.func_74764_b("value")) break;
                this.setIsWorking(tag.func_74762_e("value") == 1);
                break;
            }
            case 4: {
                if (!tag.func_74764_b("value")) break;
                this.setIsTicks(tag.func_74762_e("value") == 1);
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (!tag.func_74764_b("value")) break;
                this.time = tag.func_74762_e("value");
                break;
            }
            case 2: {
                if (!tag.func_74764_b("value")) break;
                this.isWorking = tag.func_74762_e("value") == 1;
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        tag.func_74757_a("isTicks", this.isTicks);
        tag.func_74757_a("poweredBlock", this.sendSignal);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("timer")) {
            this.time = tag.func_74762_e("timer");
        }
        if (tag.func_74764_b("startingTime")) {
            this.startingTime = tag.func_74762_e("startingTime");
        }
        if (tag.func_74764_b("invert")) {
            this.invertRedstone = tag.func_74767_n("invert");
        }
        if (tag.func_74764_b("isWorking")) {
            this.isWorking = tag.func_74767_n("isWorking");
        }
        if (tag.func_74764_b("isTicks")) {
            this.isTicks = tag.func_74767_n("isTicks");
        }
        if (tag.func_74764_b("poweredBlock")) {
            this.sendSignal = tag.func_74767_n("poweredBlock");
        }
        if (tag.func_74764_b("isPowered")) {
            this.isPowered = tag.func_74767_n("isPowered");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("timer", this.time);
        tag.func_74768_a("startingTime", this.startingTime);
        tag.func_74757_a("invert", this.invertRedstone);
        tag.func_74757_a("isWorking", this.isWorking);
        tag.func_74757_a("isTicks", this.isTicks);
        tag.func_74757_a("isPowered", this.isPowered);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    public void func_145843_s() {
        this.field_145850_b.func_175685_c(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c(), false);
        super.func_145843_s();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isWorking) {
            return;
        }
        if (this.time == 0) {
            this.setIsWorking(false);
            this.time = this.startingTime;
            return;
        }
        --this.time;
        if (this.time % 20 == 0) {
            this.notifyBlockUpdate();
        }
    }

    @Override
    public void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (block instanceof TimerBlock) {
            boolean newValue;
            boolean bl = this.time > 0 && this.isWorking ? !this.invertRedstone : (newValue = this.invertRedstone);
            if (this.sendSignal != newValue) {
                this.sendSignal = newValue;
                this.field_145850_b.func_175685_c(this.field_174879_c, block, false);
            }
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
        }
    }

    @Override
    protected boolean hasRotation() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

