/*
 * Decompiled with CFR 0.152.
 */
package elec332.craftingtableiv.handler;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import elec332.craftingtableiv.api.ICraftingTableIVAPI;
import elec332.craftingtableiv.api.IRecipeHandler;
import java.util.List;
import java.util.Set;
import net.minecraft.item.crafting.IRecipe;

public class RecipeHandler
implements ICraftingTableIVAPI {
    private static final RecipeHandler instance = new RecipeHandler();
    private Set<IRecipeHandler> registry = Sets.newHashSet();
    private List<Class<? extends IRecipe>> disabledRecipes = Lists.newArrayList();
    private boolean closed;

    private RecipeHandler() {
    }

    public static RecipeHandler getCompatHandler() {
        return instance;
    }

    @Override
    public void registerHandler(IRecipeHandler handler) {
        this.checkClosed();
        if (handler == null) {
            return;
        }
        this.registry.add(handler);
    }

    @Override
    public void registerDisabledRecipe(Class<? extends IRecipe> recipe) {
        this.checkClosed();
        if (!this.disabledRecipes.contains(recipe)) {
            this.disabledRecipes.add(recipe);
        }
    }

    @Override
    public Set<IRecipeHandler> getRegistry() {
        if (!this.closed) {
            throw new IllegalAccessError("Cannot provide registry before it's been closed!");
        }
        return this.registry;
    }

    @Override
    public boolean isRecipeDisabled(IRecipe recipe) {
        return this.isRecipeDisabled(recipe.getClass());
    }

    @Override
    public boolean isRecipeDisabled(Class<? extends IRecipe> recipeClass) {
        return this.disabledRecipes.contains(recipeClass);
    }

    public void closeRegistry() {
        this.checkClosed();
        this.registry = ImmutableSet.copyOf(this.registry);
        this.disabledRecipes = ImmutableList.copyOf(this.disabledRecipes);
        this.closed = true;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("Registry has already been closed!");
        }
    }
}

