/*
 * Decompiled with CFR 0.152.
 */
package meldexun.memoryutil;

import java.nio.FloatBuffer;
import meldexun.memoryutil.NIOBufferUtil;
import meldexun.memoryutil.PrimitiveInfo;
import meldexun.memoryutil.UnsafeNIOBuffer;

public class UnsafeFloatBuffer
extends UnsafeNIOBuffer<FloatBuffer> {
    public UnsafeFloatBuffer(long address, long capacity) {
        super(address, PrimitiveInfo.FLOAT.toByte(capacity));
    }

    public long getFloatCapacity() {
        return PrimitiveInfo.FLOAT.fromByte(this.getCapacity());
    }

    @Override
    protected FloatBuffer createBuffer() {
        return NIOBufferUtil.asFloatBuffer(this.getAddress(), this.getFloatCapacity());
    }
}

