/*
 * Decompiled with CFR 0.152.
 */
package meldexun.memoryutil;

import java.nio.LongBuffer;
import meldexun.memoryutil.NIOBufferUtil;
import meldexun.memoryutil.PrimitiveInfo;
import meldexun.memoryutil.UnsafeNIOBuffer;

public class UnsafeLongBuffer
extends UnsafeNIOBuffer<LongBuffer> {
    public UnsafeLongBuffer(long address, long capacity) {
        super(address, PrimitiveInfo.LONG.toByte(capacity));
    }

    public long getLongCapacity() {
        return PrimitiveInfo.LONG.fromByte(this.getCapacity());
    }

    @Override
    protected LongBuffer createBuffer() {
        return NIOBufferUtil.asLongBuffer(this.getAddress(), this.getLongCapacity());
    }
}

