/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.oc.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import li.cil.oc.api.event.RobotRenderEvent;
import li.cil.oc.api.internal.Robot;
import li.cil.oc.client.renderer.PetRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.computronics.item.ItemOpenComputers;
import pl.asie.computronics.oc.client.model.ModelRadar;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.util.internal.Triple;

@SideOnly(value=Side.CLIENT)
public class UpgradeRenderer {
    private final ResourceLocation upgradeRadar = new ResourceLocation("computronics", "textures/models/upgrade_radar.png");
    private final ResourceLocation modelRadar = new ResourceLocation("computronics", "textures/models/model_radar.png");
    private final ResourceLocation upgradeChatBox = new ResourceLocation("computronics", "textures/models/upgrade_chat_box.png");
    private final ResourceLocation beepCard = new ResourceLocation("computronics", "textures/models/card_beep.png");
    AxisAlignedBB bounds = new AxisAlignedBB(-0.1, -0.1, -0.1, 0.1, 0.1, 0.1);
    private static final List<Integer> upgrades = Arrays.asList(1, 2, 5, 8);
    private ModelRadar radarModel = new ModelRadar();
    private final HashMap<String, Triple> entitledPlayers;
    private final Triple WHITE;
    private boolean rendering = false;
    private long time = -1L;
    private Triple color;

    @Optional.Method(modid="opencomputers")
    private boolean isUpgrade(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemOpenComputers && upgrades.contains(stack.func_77952_i());
    }

    @Optional.Method(modid="opencomputers")
    public String computePreferredMountPoint(ItemStack stack, Robot robot, Set<String> availableMountPoints) {
        switch (stack.func_77952_i()) {
            case 1: {
                return "any";
            }
            case 2: {
                return availableMountPoints.contains("top_right") ? "top_right" : (availableMountPoints.contains("top_left") ? "top_left" : "any");
            }
            case 5: 
            case 8: {
                return availableMountPoints.contains("bottom_front") ? "bottom_front" : (availableMountPoints.contains("bottom_back") ? "bottom_back" : "any");
            }
        }
        return "none";
    }

    @Optional.Method(modid="opencomputers")
    public void render(ItemStack stack, RobotRenderEvent.MountPoint mountPoint, Robot robot, float pt) {
        if (!this.isUpgrade(stack)) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        TextureManager tm = mc.func_110434_K();
        switch (stack.func_77952_i()) {
            case 1: {
                tm.func_110577_a(this.upgradeChatBox);
                this.drawSimpleBlock(mountPoint, 0.0f);
                break;
            }
            case 2: {
                if (mountPoint.name.equals("top_left") || mountPoint.name.equals("top_right")) {
                    float degrees;
                    float f = degrees = robot.shouldAnimate() ? ((float)((robot.world().func_82737_E() + (long)(robot.hashCode() ^ 0xFF)) % 160L) + pt) / 160.0f * 360.0f : 0.0f;
                    if (mountPoint.name.equals("top_right")) {
                        degrees = 360.0f - degrees;
                    }
                    GlStateManager.func_179123_a();
                    tm.func_110577_a(this.modelRadar);
                    GlStateManager.func_179129_p();
                    GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.8f, (float)0.0f);
                    GlStateManager.func_179109_b((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
                    GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
                    GlStateManager.func_179094_E();
                    this.radarModel.render(Math.max(degrees, 0.0f));
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179099_b();
                    break;
                }
                tm.func_110577_a(this.upgradeRadar);
                this.drawSimpleBlock(mountPoint, 0.0f);
                break;
            }
            case 5: 
            case 8: {
                tm.func_110577_a(this.beepCard);
                this.drawSimpleBlock(mountPoint, 0.0f);
            }
        }
    }

    @Optional.Method(modid="opencomputers")
    private void drawSimpleBlock(RobotRenderEvent.MountPoint mountPoint, float frontOffset) {
        GlStateManager.func_179114_b((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
        GlStateManager.func_179109_b((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder r = t.func_178180_c();
        r.func_181668_a(7, DefaultVertexFormats.field_181710_j);
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a((double)frontOffset, 0.5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a((double)(frontOffset + 0.5f), 0.5).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a((double)(frontOffset + 0.5f), 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a((double)frontOffset, 0.0).func_181663_c(0.0f, 0.0f, 1.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a(1.0, 0.5).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72339_c).func_187315_a(1.0, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72337_e, this.bounds.field_72339_c).func_187315_a(0.5, 1.0).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a(0.5, 0.5).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a(0.5, 0.5).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72339_c).func_187315_a(0.5, 1.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72338_b, this.bounds.field_72339_c).func_187315_a(1.0, 1.0).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a(1.0, 0.5).func_181663_c(0.0f, -1.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a(0.0, 0.5).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a(0.0, 1.0).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72338_b, this.bounds.field_72339_c).func_187315_a(0.5, 1.0).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72336_d, this.bounds.field_72337_e, this.bounds.field_72339_c).func_187315_a(0.5, 0.5).func_181663_c(1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72334_f).func_187315_a(0.0, 1.0).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72337_e, this.bounds.field_72334_f).func_187315_a(0.0, 0.5).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72337_e, this.bounds.field_72339_c).func_187315_a(0.5, 0.5).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        r.func_181662_b(this.bounds.field_72340_a, this.bounds.field_72338_b, this.bounds.field_72339_c).func_187315_a(0.5, 1.0).func_181663_c(-1.0f, 0.0f, 0.0f).func_181675_d();
        t.func_78381_a();
    }

    public UpgradeRenderer() {
        if (!Mods.isLoaded("opencomputers")) {
            this.entitledPlayers = null;
            this.WHITE = null;
            return;
        }
        this.entitledPlayers = new HashMap();
        this.WHITE = new Triple(1.0f, 1.0f, 1.0f);
        this.entitledPlayers.put("f3ba6ec8-c280-4950-bb08-1fcb2eab3a9c", this.WHITE);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    @Optional.Method(modid="opencomputers")
    public void onPlayerTickPre(RenderPlayerEvent.Pre e) {
        String uuid = e.getEntityPlayer().func_110124_au().toString();
        if (PetRenderer.hidden().contains((Object)uuid) || !this.entitledPlayers.containsKey(uuid)) {
            return;
        }
        this.rendering = true;
        this.time = e.getEntityPlayer().func_130014_f_().func_82737_E() + (long)(e.getEntityPlayer().hashCode() ^ 0xFF);
        this.color = this.entitledPlayers.get(uuid);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @Optional.Method(modid="opencomputers")
    public void onRobotRender(RobotRenderEvent e) {
        if (!this.rendering) {
            return;
        }
        if (e.mountPoints == null || e.mountPoints.length < 2) {
            return;
        }
        RobotRenderEvent.MountPoint mountPoint = e.mountPoints[1];
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179124_c((float)this.color.r, (float)this.color.g, (float)this.color.b);
        float degrees = 360.0f - (float)(this.time % 160L) / 160.0f * 360.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.modelRadar);
        GlStateManager.func_179129_p();
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)mountPoint.rotation.getW(), (float)mountPoint.rotation.getX(), (float)mountPoint.rotation.getY(), (float)mountPoint.rotation.getZ());
        GlStateManager.func_179109_b((float)0.0f, (float)-0.8f, (float)0.0f);
        GlStateManager.func_179109_b((float)mountPoint.offset.getX(), (float)mountPoint.offset.getY(), (float)mountPoint.offset.getZ());
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        GlStateManager.func_179094_E();
        this.radarModel.render(Math.max(degrees, 0.0f));
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @Optional.Method(modid="opencomputers")
    public void onPlayerTickPost(RenderPlayerEvent.Pre e) {
        if (this.rendering) {
            this.rendering = false;
            this.time = -1L;
            this.color = this.WHITE;
        }
    }
}

