/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.util.color;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.lib.util.ColorUtils;
import pl.asie.lib.util.color.ItemColorizer;

public class RecipeColorizer
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final Item targetItem;
    private List<Item> sourceItems;

    public RecipeColorizer(Item targetItem, List<Item> sourceItems) {
        this.targetItem = targetItem;
        this.sourceItems = sourceItems;
    }

    public RecipeColorizer(Item item) {
        this.targetItem = item;
        this.sourceItems = new ArrayList<Item>(1);
        this.sourceItems.add(item);
    }

    public boolean func_77569_a(InventoryCrafting crafting, World par2World) {
        boolean hasTargetStack = false;
        boolean hasDye = false;
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            ItemStack stack = crafting.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (!hasTargetStack && (this.sourceItems.contains(stack.func_77973_b()) || this.targetItem == stack.func_77973_b())) {
                hasTargetStack = true;
                continue;
            }
            if (ColorUtils.getColor(stack) != null) {
                hasDye = true;
                continue;
            }
            return false;
        }
        return hasTargetStack && hasDye;
    }

    public ItemStack func_77572_b(InventoryCrafting crafting) {
        ItemStack targetStack = ItemStack.field_190927_a;
        int[] color = new int[3];
        int colorCount = 0;
        int maximum = 0;
        for (int i = 0; i < crafting.func_70302_i_(); ++i) {
            ItemStack stack = crafting.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.sourceItems.contains(stack.func_77973_b()) || this.targetItem == stack.func_77973_b()) {
                targetStack = stack.func_77946_l();
                targetStack.func_190920_e(1);
                continue;
            }
            ColorUtils.Color stackColor = ColorUtils.getColor(stack);
            if (stackColor == null) {
                return ItemStack.field_190927_a;
            }
            float[] itemColor = EnumDyeColor.func_176766_a((int)stackColor.ordinal()).func_193349_f();
            int red = (int)(itemColor[0] * 255.0f);
            int green = (int)(itemColor[1] * 255.0f);
            int blue = (int)(itemColor[2] * 255.0f);
            maximum += Math.max(red, Math.max(green, blue));
            color[0] = color[0] + red;
            color[1] = color[1] + green;
            color[2] = color[2] + blue;
            ++colorCount;
        }
        if (targetStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.targetItem.getClass().isInstance(targetStack.func_77973_b())) {
            if (ItemColorizer.hasColor(targetStack)) {
                int itemColor = ItemColorizer.getColor(targetStack);
                float red = (float)(itemColor >> 16 & 0xFF) / 255.0f;
                float green = (float)(itemColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(itemColor & 0xFF) / 255.0f;
                maximum = (int)((float)maximum + Math.max(red, Math.max(green, blue)) * 255.0f);
                color[0] = (int)((float)color[0] + red * 255.0f);
                color[1] = (int)((float)color[1] + green * 255.0f);
                color[2] = (int)((float)color[2] + blue * 255.0f);
                ++colorCount;
            }
        } else if (this.sourceItems.contains(targetStack.func_77973_b())) {
            targetStack = new ItemStack(this.targetItem, targetStack.func_190916_E(), targetStack.func_77952_i());
        }
        int red = color[0] / colorCount;
        int green = color[1] / colorCount;
        int blue = color[2] / colorCount;
        float max = (float)maximum / (float)colorCount;
        float div = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * max / div);
        green = (int)((float)green * max / div);
        blue = (int)((float)blue * max / div);
        ItemColorizer.setColor(targetStack, red << 16 | green << 8 | blue);
        return targetStack;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

