/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.gameObjs.blocks.MatterFurnace;
import moze_intel.projecte.gameObjs.container.slots.SlotPredicates;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.gameObjs.tiles.WrappedItemHandler;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class RMFurnaceTile
extends TileEmc
implements IEmcAcceptor {
    private static final long EMC_CONSUMPTION = 2L;
    private final ItemStackHandler inputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler outputInventory = new TileEmc.StackHandler(this, this.getInvSize());
    private final ItemStackHandler fuelInv = new TileEmc.StackHandler(this, 1);
    private final IItemHandlerModifiable automationInput = new WrappedItemHandler((IItemHandlerModifiable)this.inputInventory, WrappedItemHandler.WriteMode.IN){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.SMELTABLE.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandlerModifiable automationFuel = new WrappedItemHandler((IItemHandlerModifiable)this.fuelInv, WrappedItemHandler.WriteMode.IN){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return SlotPredicates.FURNACE_FUEL.test(stack) ? super.insertItem(slot, stack, simulate) : stack;
        }
    };
    private final IItemHandlerModifiable automationOutput = new WrappedItemHandler((IItemHandlerModifiable)this.outputInventory, WrappedItemHandler.WriteMode.OUT);
    private final IItemHandler automationSides = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationFuel, this.automationOutput});
    private final CombinedInvWrapper joined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.automationInput, this.automationFuel, this.automationOutput});
    protected final int ticksBeforeSmelt;
    private final int efficiencyBonus;
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int furnaceCookTime;

    public RMFurnaceTile() {
        this(3, 4);
    }

    protected RMFurnaceTile(int ticksBeforeSmelt, int efficiencyBonus) {
        super(64L);
        this.ticksBeforeSmelt = ticksBeforeSmelt;
        this.efficiencyBonus = efficiencyBonus;
    }

    protected int getInvSize() {
        return 13;
    }

    protected float getOreDoubleChance() {
        return 1.0f;
    }

    public IItemHandler getFuel() {
        return this.fuelInv;
    }

    private ItemStack getFuelItem() {
        return this.fuelInv.getStackInSlot(0);
    }

    public IItemHandler getInput() {
        return this.inputInventory;
    }

    public IItemHandler getOutput() {
        return this.outputInventory;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(cap, side);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.joined);
            }
            switch (side) {
                case UP: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationInput);
                }
                case DOWN: {
                    return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationOutput);
                }
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.automationSides);
        }
        return (T)super.getCapability(cap, side);
    }

    public void func_73660_a() {
        boolean flag = this.furnaceBurnTime > 0;
        boolean flag1 = false;
        this.furnaceBurnTime = this.furnaceBurnTime > 0 ? --this.furnaceBurnTime : 0;
        if (!this.func_145831_w().field_72995_K) {
            IItemEmc itemEmc;
            this.pullFromInventories();
            ItemHelper.compactInventory((IItemHandlerModifiable)this.inputInventory);
            if (this.canSmelt() && !this.getFuelItem().func_190926_b() && this.getFuelItem().func_77973_b() instanceof IItemEmc && (itemEmc = (IItemEmc)this.getFuelItem().func_77973_b()).getStoredEmc(this.getFuelItem()) >= 2L) {
                itemEmc.extractEmc(this.getFuelItem(), 2L);
                this.addEMC(2L);
            }
            if (this.getStoredEmc() >= 2L) {
                this.furnaceBurnTime = 1;
                this.removeEMC(2L);
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = this.getItemBurnTime(this.getFuelItem());
                if (this.furnaceBurnTime > 0) {
                    flag1 = true;
                    if (!this.getFuelItem().func_190926_b()) {
                        ItemStack copy = this.getFuelItem().func_77946_l();
                        this.getFuelItem().func_190918_g(1);
                        if (this.getFuelItem().func_190926_b()) {
                            this.fuelInv.setStackInSlot(0, copy.func_77973_b().getContainerItem(copy));
                        }
                    }
                }
            }
            if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == this.ticksBeforeSmelt) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    flag1 = true;
                }
            }
            if (flag != this.furnaceBurnTime > 0) {
                flag1 = true;
                Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
                if (!this.func_145831_w().field_72995_K && block instanceof MatterFurnace) {
                    ((MatterFurnace)block).updateFurnaceBlockState(this.furnaceBurnTime > 0, this.field_145850_b, this.func_174877_v());
                }
            }
            if (flag1) {
                this.func_70296_d();
            }
            ItemHelper.compactInventory((IItemHandlerModifiable)this.outputInventory);
            this.pushToInventories();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private void pullFromInventories() {
        TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177984_a());
        if (tile == null || tile instanceof TileEntityHopper || tile instanceof TileEntityDropper) {
            return;
        }
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
        if (handler == null) {
            if (tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, EnumFacing.DOWN);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            } else {
                return;
            }
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack extractTest = handler.extractItem(i, Integer.MAX_VALUE, true);
            if (extractTest.func_190926_b()) continue;
            ItemStackHandler targetInv = extractTest.func_77973_b() instanceof IItemEmc || TileEntityFurnace.func_145954_b((ItemStack)extractTest) ? this.fuelInv : this.inputInventory;
            ItemStack remainderTest = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)extractTest, (boolean)true);
            int successfullyTransferred = extractTest.func_190916_E() - remainderTest.func_190916_E();
            if (successfullyTransferred <= 0) continue;
            ItemStack toInsert = handler.extractItem(i, successfullyTransferred, false);
            ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)targetInv, (ItemStack)toInsert, (boolean)false);
            assert (result.func_190926_b());
        }
    }

    private void pushToInventories() {
        block0: for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(direction));
            if (direction == EnumFacing.UP || tile == null || tile instanceof TileEntityHopper || tile instanceof TileEntityDropper) continue;
            IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
            if (handler == null) {
                if (tile instanceof ISidedInventory) {
                    handler = new SidedInvWrapper((ISidedInventory)tile, direction.func_176734_d());
                } else {
                    if (!(tile instanceof IInventory)) continue;
                    handler = new InvWrapper((IInventory)tile);
                }
            }
            for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
                ItemStack stackInSlot = this.outputInventory.getStackInSlot(i);
                if (stackInSlot.func_190926_b() || stackInSlot.func_190916_E() < stackInSlot.func_77976_d()) continue;
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stackInSlot, (boolean)false);
                int successfullyTransferred = stackInSlot.func_190916_E() - remainder.func_190916_E();
                if (successfullyTransferred <= 0) continue;
                this.outputInventory.extractItem(i, successfullyTransferred, false);
                if (this.outputInventory.getStackInSlot(i).func_190926_b()) continue block0;
            }
        }
    }

    private void smeltItem() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt).func_77946_l();
        if (this.field_145850_b.field_73012_v.nextFloat() < this.getOreDoubleChance() && ItemHelper.getOreDictionaryName(toSmelt).startsWith("ore")) {
            smeltResult.func_190917_f(smeltResult.func_190916_E());
        }
        ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputInventory, (ItemStack)smeltResult, (boolean)false);
        toSmelt.func_190918_g(1);
    }

    private boolean canSmelt() {
        ItemStack toSmelt = this.inputInventory.getStackInSlot(0);
        if (toSmelt.func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt);
        if (smeltResult.func_190926_b()) {
            return false;
        }
        ItemStack currentSmelted = this.outputInventory.getStackInSlot(this.outputInventory.getSlots() - 1);
        if (currentSmelted.func_190926_b()) {
            return true;
        }
        if (!smeltResult.func_77969_a(currentSmelted)) {
            return false;
        }
        int result = currentSmelted.func_190916_E() + smeltResult.func_190916_E();
        return result <= currentSmelted.func_77976_d();
    }

    private int getItemBurnTime(ItemStack stack) {
        int val = TileEntityFurnace.func_145952_a((ItemStack)stack);
        return val * this.ticksBeforeSmelt / 200 * this.efficiencyBonus;
    }

    public int getCookProgressScaled(int value) {
        return (this.furnaceCookTime + (this.isBurning() && this.canSmelt() ? 1 : 0)) * value / this.ticksBeforeSmelt;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int value) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = this.ticksBeforeSmelt;
        }
        return this.furnaceBurnTime * value / this.currentItemBurnTime;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.furnaceBurnTime = nbt.func_74762_e("BurnTime");
        this.furnaceCookTime = nbt.func_74762_e("CookTime");
        this.inputInventory.deserializeNBT(nbt.func_74775_l("Input"));
        this.outputInventory.deserializeNBT(nbt.func_74775_l("Output"));
        this.fuelInv.deserializeNBT(nbt.func_74775_l("Fuel"));
        this.currentItemBurnTime = nbt.func_74762_e("CurrentItemBurnTime");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        nbt.func_74768_a("BurnTime", this.furnaceBurnTime);
        nbt.func_74768_a("CookTime", this.furnaceCookTime);
        nbt.func_74768_a("CurrentItemBurnTime", this.currentItemBurnTime);
        nbt.func_74782_a("Input", (NBTBase)this.inputInventory.serializeNBT());
        nbt.func_74782_a("Output", (NBTBase)this.outputInventory.serializeNBT());
        nbt.func_74782_a("Fuel", (NBTBase)this.fuelInv.serializeNBT());
        return nbt;
    }

    @Override
    public long acceptEMC(@Nonnull EnumFacing side, long toAccept) {
        if (this.getStoredEmc() < 2L) {
            long needed = 2L - this.getStoredEmc();
            long accept = Math.min(needed, toAccept);
            this.addEMC(accept);
            return accept;
        }
        return 0L;
    }
}

