/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import moze_intel.projecte.utils.Comparators;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFishingRod;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public final class ItemHelper {
    public static boolean areItemStacksEqual(ItemStack stack1, ItemStack stack2) {
        return ItemStack.func_77989_b((ItemStack)ItemHelper.getNormalizedStack(stack1), (ItemStack)ItemHelper.getNormalizedStack(stack2));
    }

    public static boolean areItemStacksEqualIgnoreNBT(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() != stack2.func_77973_b()) {
            return false;
        }
        if (stack1.func_77952_i() == Short.MAX_VALUE || stack2.func_77952_i() == Short.MAX_VALUE) {
            return true;
        }
        return stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static boolean basicAreStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77952_i() == stack2.func_77952_i();
    }

    public static void compactInventory(IItemHandlerModifiable inventory) {
        ArrayList<ItemStack> temp = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            if (inventory.getStackInSlot(i).func_190926_b()) continue;
            temp.add(inventory.getStackInSlot(i));
            inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (ItemStack s : temp) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)inventory, (ItemStack)s, (boolean)false);
        }
    }

    public static void compactItemListNoStacksize(List<ItemStack> list) {
        for (int i = 0; i < list.size(); ++i) {
            ItemStack s = list.get(i);
            if (s.func_190926_b()) continue;
            for (int j = i + 1; j < list.size(); ++j) {
                ItemStack s1 = list.get(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)s1)) continue;
                s.func_190917_f(s1.func_190916_E());
                list.set(j, ItemStack.field_190927_a);
            }
        }
        list.stream().filter(stack -> !stack.func_190926_b()).collect(Collectors.toList()).sort(Comparators.ITEMSTACK_ASCENDING);
    }

    public static void removeEmptyTags(List<ItemStack> list) {
        for (ItemStack s : list) {
            if (s.func_190926_b() || !s.func_77942_o() || !s.func_77978_p().func_82582_d()) continue;
            s.func_77982_d(null);
        }
    }

    public static boolean containsItemStack(List<ItemStack> list, ItemStack toSearch) {
        for (ItemStack stack : list) {
            if (stack.func_190926_b() || !stack.func_77973_b().equals(toSearch.func_77973_b()) || stack.func_77981_g() && stack.func_77952_i() != toSearch.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static ItemStack getNormalizedStack(ItemStack stack) {
        ItemStack result = stack.func_77946_l();
        result.func_190920_e(1);
        return result;
    }

    public static List<ItemStack> getODItems(String oreName) {
        NonNullList result = NonNullList.func_191196_a();
        for (ItemStack stack : OreDictionary.getOres((String)oreName)) {
            if (stack.func_190926_b()) continue;
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, result);
                continue;
            }
            result.add((Object)stack.func_77946_l());
        }
        return result;
    }

    public static NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static String getOreDictionaryName(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "Unknown";
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIds.length == 0) {
            return "Unknown";
        }
        return OreDictionary.getOreName((int)oreIds[0]);
    }

    public static boolean hasSpace(NonNullList<ItemStack> inv, ItemStack stack) {
        for (ItemStack invStack : inv) {
            if (invStack.func_190926_b()) {
                return true;
            }
            if (!ItemHelper.areItemStacksEqual(stack, invStack) || invStack.func_190916_E() >= invStack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemRepairable(ItemStack stack) {
        if (stack.func_77981_g()) {
            return false;
        }
        if (stack.func_77958_k() == 0 || stack.func_77952_i() == 0) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemShears || item instanceof ItemFlintAndSteel || item instanceof ItemFishingRod || item instanceof ItemBow) {
            return true;
        }
        return item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe || item instanceof ItemArmor;
    }

    public static IItemHandlerModifiable immutableCopy(IItemHandler toCopy) {
        final ArrayList<ItemStack> list = new ArrayList<ItemStack>(toCopy.getSlots());
        for (int i = 0; i < toCopy.getSlots(); ++i) {
            list.add(toCopy.getStackInSlot(i));
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            }

            public int getSlots() {
                return list.size();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return (ItemStack)list.get(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            public int getSlotLimit(int slot) {
                return this.getStackInSlot(slot).func_77976_d();
            }
        };
    }

    public static boolean isDamageable(ItemStack stack) {
        return !stack.func_77981_g() && stack.func_77984_f();
    }

    public static boolean isOre(IBlockState state) {
        if (state.func_177230_c() == Blocks.field_150439_ay) {
            return true;
        }
        if (Item.func_150898_a((Block)state.func_177230_c()) == Items.field_190931_a) {
            return false;
        }
        String oreDictName = ItemHelper.getOreDictionaryName(ItemHelper.stateToStack(state, 1));
        return oreDictName.startsWith("ore") || oreDictName.startsWith("denseore");
    }

    public static IBlockState stackToState(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            return ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
        }
        return null;
    }

    public static ItemStack stateToStack(IBlockState state, int stackSize) {
        return new ItemStack(state.func_177230_c(), stackSize, state.func_177230_c().func_176201_c(state));
    }

    public static ItemStack stateToDroppedStack(IBlockState state, int stackSize) {
        return new ItemStack(state.func_177230_c(), stackSize, state.func_177230_c().func_180651_a(state));
    }
}

