/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.client.events;

import com.verdantartifice.thaumicwonders.common.init.InitBlocks;
import com.verdantartifice.thaumicwonders.common.init.InitItems;
import com.verdantartifice.thaumicwonders.common.items.base.IVariantItem;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="thaumicwonders")
public class ModelRegistrationEvents {
    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        ModelRegistrationEvents.registerItemBlockModels();
        ModelRegistrationEvents.registerItemModels();
        ModelRegistrationEvents.registerVariantModels();
    }

    private static void registerItemBlockModels() {
        for (ItemBlock itemBlock : InitBlocks.ITEM_BLOCKS) {
            ModelRegistrationEvents.registerItemModel((Item)itemBlock);
        }
    }

    private static void registerItemModels() {
        for (Item item : InitItems.ITEMS) {
            ModelRegistrationEvents.registerItemModel(item);
        }
    }

    private static void registerItemModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void registerVariantModels() {
        for (IVariantItem variantHolder : InitItems.ITEM_VARIANT_HOLDERS) {
            ModelRegistrationEvents.registerVariantModel(variantHolder);
        }
    }

    private static void registerVariantModel(IVariantItem item) {
        for (int i = 0; i < item.getVariantNames().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item.getItem(), (int)item.getVariantMeta()[i], (ModelResourceLocation)item.getCustomModelResourceLocation(item.getVariantNames()[i]));
        }
    }
}

