/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.entities;

import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import com.verdantartifice.thaumicwonders.common.items.entities.ItemFlyingCarpet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFlyingCarpet
extends Entity {
    private static final DataParameter<Integer> VIS_CHARGE = EntityDataManager.func_187226_a(EntityFlyingCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> ENERGY = EntityDataManager.func_187226_a(EntityFlyingCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DYE_COLOR = EntityDataManager.func_187226_a(EntityFlyingCarpet.class, (DataSerializer)DataSerializers.field_187192_b);
    private float momentum;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYaw;
    private double lerpPitch;
    private boolean forwardInputDown;
    private boolean backInputDown;

    public EntityFlyingCarpet(World worldIn) {
        super(worldIn);
        this.field_70156_m = true;
        this.func_70105_a(1.0f, 0.0625f);
        this.func_189654_d(true);
    }

    public EntityFlyingCarpet(World worldIn, double x, double y, double z) {
        this(worldIn);
        this.func_70107_b(x, y, z);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public EntityFlyingCarpet(World worldIn, BlockPos pos) {
        this(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(VIS_CHARGE, (Object)0);
        this.field_70180_af.func_187214_a(ENERGY, (Object)0);
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)-1);
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return entityIn.func_70104_M() ? entityIn.func_174813_aQ() : null;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return -0.15;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.lerpX = x;
        this.lerpY = y;
        this.lerpZ = z;
        this.lerpYaw = yaw;
        this.lerpPitch = pitch;
        this.lerpSteps = 10;
    }

    public EnumFacing func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        super.func_70071_h_();
        this.tickLerp();
        if (this.func_184207_aI() && !this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            this.consumeEnergy();
            this.func_189654_d(this.hasEnergy());
        }
        if (this.func_184207_aI() && this.func_184186_bw()) {
            this.updateMotion();
            if (this.field_70170_p.field_72995_K && this.hasEnergy()) {
                this.controlCarpet();
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            if (this.field_70170_p.field_72995_K) {
                this.updateInputs(false, false);
            }
        }
        this.func_145775_I();
    }

    private void consumeEnergy() {
        int energy = this.getEnergy();
        if (energy > 0) {
            --energy;
        } else {
            int visCharge = this.getVisCharge();
            if (visCharge > 0) {
                energy = 30;
                this.setVisCharge(visCharge - 1);
            }
        }
        this.setEnergy(energy);
    }

    private boolean hasEnergy() {
        return this.getEnergy() > 0 || this.getVisCharge() > 0;
    }

    private void tickLerp() {
        if (this.lerpSteps > 0 && !this.func_184186_bw()) {
            double newX = this.field_70165_t + (this.lerpX - this.field_70165_t) / (double)this.lerpSteps;
            double newY = this.field_70163_u + (this.lerpY - this.field_70163_u) / (double)this.lerpSteps;
            double newZ = this.field_70161_v + (this.lerpZ - this.field_70161_v) / (double)this.lerpSteps;
            double deltaYaw = MathHelper.func_76138_g((double)(this.lerpYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + deltaYaw / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpPitch - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(newX, newY, newZ);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    private void updateMotion() {
        this.momentum = 0.9f;
        this.field_70159_w *= (double)this.momentum;
        this.field_70181_x *= (double)this.momentum;
        this.field_70179_y *= (double)this.momentum;
        this.field_70181_x += this.func_189652_ae() ? 0.0 : -0.04;
    }

    private void controlCarpet() {
        if (this.func_184207_aI()) {
            Entity pilot = this.func_184179_bs();
            this.field_70126_B = this.field_70177_z;
            this.field_70177_z = pilot.field_70177_z;
            float f = 0.0f;
            if (this.forwardInputDown) {
                f += 0.03f;
            }
            if (this.backInputDown) {
                f -= 0.005f;
            }
            this.field_70159_w += (double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f);
            this.field_70181_x += (double)(MathHelper.func_76126_a((float)(-pilot.field_70125_A * ((float)Math.PI / 180))) * f);
            this.field_70179_y += (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f);
        }
    }

    public void updateInputs(boolean forwardDown, boolean backwardDown) {
        this.forwardInputDown = forwardDown;
        this.backInputDown = backwardDown;
    }

    protected void applyYawToEntity(Entity entityToUpdate) {
        entityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(entityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        entityToUpdate.field_70126_B += f1 - f;
        entityToUpdate.field_70177_z += f1 - f;
        entityToUpdate.func_70034_d(entityToUpdate.field_70177_z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_184190_l(Entity entityToUpdate) {
        this.applyYawToEntity(entityToUpdate);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_70093_af()) {
                ItemStack itemStack = new ItemStack(ItemsTW.FLYING_CARPET, 1, 0);
                EnumDyeColor color = this.getDyeColor();
                if (color != null) {
                    ((ItemFlyingCarpet)itemStack.func_77973_b()).setDyeColor(itemStack, color);
                }
                itemStack.func_77983_a("tc.charge", (NBTBase)new NBTTagInt(this.getVisCharge()));
                itemStack.func_77983_a("energy", (NBTBase)new NBTTagInt(this.getEnergy()));
                this.func_70099_a(itemStack, 0.0f);
                this.func_70106_y();
            } else {
                player.func_184220_m((Entity)this);
            }
        }
        return true;
    }

    public void setVisCharge(int visCharge) {
        this.field_70180_af.func_187227_b(VIS_CHARGE, (Object)visCharge);
    }

    public int getVisCharge() {
        return (Integer)this.field_70180_af.func_187225_a(VIS_CHARGE);
    }

    public void setEnergy(int energy) {
        this.field_70180_af.func_187227_b(ENERGY, (Object)energy);
    }

    public int getEnergy() {
        return (Integer)this.field_70180_af.func_187225_a(ENERGY);
    }

    public void setDyeColor(EnumDyeColor color) {
        if (color == null) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)-1);
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)color.func_176765_a());
        }
    }

    public EnumDyeColor getDyeColor() {
        int value = (Integer)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (value == -1) {
            return null;
        }
        return EnumDyeColor.func_176764_b((int)value);
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        Entity retVal = list.isEmpty() ? null : (Entity)list.get(0);
        return retVal;
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.lerpSteps > 0) {
            this.lerpSteps = 0;
            this.field_70165_t = this.lerpX;
            this.field_70163_u = this.lerpY;
            this.field_70161_v = this.lerpZ;
            this.field_70177_z = (float)this.lerpYaw;
            this.field_70125_A = (float)this.lerpPitch;
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
        this.field_70143_R = 0.0f;
        if (this.func_184207_aI()) {
            this.func_184179_bs().field_70143_R = 0.0f;
        }
    }
}

