/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.entities.monsters;

import com.google.common.base.Predicate;
import com.verdantartifice.thaumicwonders.common.entities.EntityFluxFireball;
import com.verdantartifice.thaumicwonders.common.items.ItemsTW;
import com.verdantartifice.thaumicwonders.common.misc.FluxExplosion;
import com.verdantartifice.thaumicwonders.common.network.PacketHandler;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketAvatarZapFx;
import com.verdantartifice.thaumicwonders.common.network.packets.PacketLocalizedMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.entities.IEldritchMob;
import thaumcraft.api.entities.ITaintedMob;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.potions.PotionFluxTaint;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeed;
import thaumcraft.common.entities.monster.tainted.EntityTaintSeedPrime;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.potions.PotionInfectiousVisExhaust;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityCorruptionAvatar
extends EntityThaumcraftBoss
implements IRangedAttackMob,
IEldritchMob,
ITaintedMob {
    protected int seedCooldown = 0;
    protected boolean isSuffocating = false;
    protected static final Predicate<Entity> NOT_HORROR = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return !(input instanceof IEldritchMob) && !(input instanceof ITaintedMob);
        }
    };

    public EntityCorruptionAvatar(World world) {
        super(world);
        this.func_70105_a(0.75f, 2.25f);
        this.field_70728_aV = 200;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILongRangeAttack((IRangedAttackMob)this, 4.0, 0.8, 30, 40, 24.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.8, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 0, false, false, NOT_HORROR));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(6.0);
    }

    public boolean func_184191_r(Entity el) {
        return el instanceof IEldritchMob || el instanceof ITaintedMob || super.func_184191_r(el);
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return !IEldritchMob.class.isAssignableFrom(cls) && !ITaintedMob.class.isAssignableFrom(cls) && super.func_70686_a(cls);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (this.func_70685_l((Entity)target)) {
            this.func_184609_a(this.func_184600_cs());
            this.func_70671_ap().func_75650_a(target.field_70165_t, target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f), target.field_70161_v, 30.0f, 30.0f);
            double sourceY = this.field_70163_u + (double)(this.field_70131_O / 2.0f);
            double deltaX = target.field_70165_t - this.field_70165_t;
            double deltaY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 2.0f) - sourceY;
            double deltaZ = target.field_70161_v - this.field_70161_v;
            EntityFluxFireball fireball = new EntityFluxFireball(this.field_70170_p, (EntityLivingBase)this, deltaX, deltaY, deltaZ);
            fireball.field_70165_t = this.field_70165_t;
            fireball.field_70163_u = sourceY;
            fireball.field_70161_v = this.field_70161_v;
            this.func_184185_a(SoundsTC.egattack, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)fireball);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)ItemsTW.VOIDCALLER_HELM));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)ItemsTW.VOIDCALLER_CHEST));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)ItemsTW.VOIDCALLER_LEGS));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsTC.voidBoots));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData data) {
        this.func_180481_a(diff);
        this.func_180483_b(diff);
        return super.func_180482_a(diff, data);
    }

    protected void func_70619_bc() {
        if (!this.field_70170_p.field_72995_K) {
            List riftsNearby;
            int riftCount;
            if (this.field_70173_aa % 5 == 0) {
                AuraHelper.polluteAura((World)this.field_70170_p, (BlockPos)this.func_180425_c().func_177984_a(), (float)1.0f, (boolean)true);
            }
            if (this.field_70173_aa % 40 == 0) {
                float flux = Math.min(100.0f, AuraHelper.getFlux((World)this.field_70170_p, (BlockPos)this.func_180425_c()));
                int amp = (int)(0.5f * MathHelper.func_76129_c((float)flux));
                this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 40, amp, false, false));
            }
            if (this.field_70173_aa % 20 == 0) {
                List livingNearby = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (Entity)this, EntityLivingBase.class, (double)8.0);
                for (EntityLivingBase creature : livingNearby) {
                    creature.func_70690_d(new PotionEffect(PotionInfectiousVisExhaust.instance, 100, 3));
                    creature.func_70690_d(new PotionEffect(PotionFluxTaint.instance, 100, 0));
                }
            }
            if (++this.seedCooldown >= 200) {
                EnumDifficulty diff = this.field_70170_p.func_175659_aa();
                int maxSeeds = diff == EnumDifficulty.EASY ? 1 : (diff == EnumDifficulty.HARD ? 4 : 2);
                List seedsNearby = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (Entity)this, EntityTaintSeed.class, (double)16.0);
                if (seedsNearby.size() < maxSeeds) {
                    int primeThreshold;
                    int n = diff == EnumDifficulty.EASY ? -1 : (primeThreshold = diff == EnumDifficulty.HARD ? 1 : 0);
                    int boost = diff == EnumDifficulty.EASY ? 50 : (diff == EnumDifficulty.HARD ? 200 : 100);
                    EntityTaintSeedPrime seed = this.field_70146_Z.nextInt(10) <= primeThreshold ? new EntityTaintSeedPrime(this.field_70170_p) : new EntityTaintSeed(this.field_70170_p);
                    seed.boost = boost;
                    seed.func_70012_b((double)((int)(this.field_70165_t + this.field_70146_Z.nextGaussian() * 5.0)) + 0.5, (double)((int)(this.field_70163_u + this.field_70146_Z.nextGaussian() * 5.0)), (double)((int)(this.field_70161_v + this.field_70146_Z.nextGaussian() * 5.0)) + 0.5, (float)this.field_70146_Z.nextInt(360), 0.0f);
                    if (diff != EnumDifficulty.PEACEFUL && seed.func_70058_J() && this.field_70170_p.func_72838_d((Entity)seed)) {
                        this.func_70671_ap().func_75651_a((Entity)seed, (float)this.func_184649_cE(), (float)this.func_70646_bf());
                        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketAvatarZapFx(this.func_145782_y(), seed.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
                        this.func_184185_a(SoundsTC.zap, 1.0f, 1.0f);
                        this.seedCooldown = 0;
                    }
                }
            }
            if (this.field_70173_aa % 200 == 0 && (riftCount = (riftsNearby = EntityUtils.getEntitiesInRange((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (Entity)this, EntityFluxRift.class, (double)16.0)).size()) > 0) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 200, 3 + riftCount));
                this.func_70690_d(new PotionEffect(MobEffects.field_76422_e, 200, riftCount));
                for (EntityFluxRift rift : riftsNearby) {
                    PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketAvatarZapFx(rift.func_145782_y(), this.func_145782_y()), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), rift.field_70165_t, rift.field_70163_u, rift.field_70161_v, 32.0));
                    rift.func_184185_a(SoundsTC.zap, 1.0f, 1.0f);
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketLocalizedMessage("event.corruption_avatar.empower"), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
            }
            if (this.isSuffocating && this.field_70173_aa % 20 == 0) {
                FluxExplosion.create(this.field_70170_p, (Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 7.0f, false, true, true);
                this.isSuffocating = false;
            }
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source == DamageSource.field_76369_e || source.func_76346_g() instanceof EntityCorruptionAvatar) {
            return false;
        }
        if (source == DamageSource.field_76368_d) {
            this.isSuffocating = true;
        }
        return super.func_70097_a(source, amount);
    }

    protected SoundEvent func_184639_G() {
        return SoundsTC.egidle;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsTC.egdeath;
    }

    public int func_70627_aG() {
        return 500;
    }
}

