/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.network.packets;

import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.common.lib.utils.Utils;

public class PacketTileToServer
implements IMessage {
    private long pos;
    private NBTTagCompound nbt;

    public PacketTileToServer() {
    }

    public PacketTileToServer(BlockPos pos, NBTTagCompound nbt) {
        this.pos = pos.func_177986_g();
        this.nbt = nbt;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        this.nbt = Utils.readNBTTagCompoundFromBuffer((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
        Utils.writeNBTTagCompoundToBuffer((ByteBuf)buf, (NBTTagCompound)this.nbt);
    }

    public static class Handler
    implements IMessageHandler<PacketTileToServer, IMessage> {
        public IMessage onMessage(PacketTileToServer message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketTileToServer message, MessageContext ctx) {
            TileEntity tile;
            WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
            BlockPos bp = BlockPos.func_177969_a((long)message.pos);
            if (world != null && bp != null && (tile = world.func_175625_s(bp)) != null && tile instanceof TileTW) {
                ((TileTW)tile).messageFromClient(message.nbt == null ? new NBTTagCompound() : message.nbt, ctx.getServerHandler().field_147369_b);
            }
        }
    }
}

