/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.blocks.BlocksTW;
import com.verdantartifice.thaumicwonders.common.blocks.devices.BlockCoalescenceMatrix;
import com.verdantartifice.thaumicwonders.common.entities.monsters.EntityCorruptionAvatar;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.casters.IInteractWithCaster;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.blocks.basic.BlockPillar;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;

public class TileCoalescenceMatrix
extends TileTW
implements ITickable,
IInteractWithCaster {
    protected static final int PROGRESS_PER_CHARGE = 50;
    protected static final int MAX_CHARGE = 10;
    protected static final int PLAY_EFFECTS = 4;
    protected int tickCounter = 0;
    protected int progress = 0;

    public int getProgress() {
        return this.progress;
    }

    public void incrementProgress(int amount) {
        int charge;
        this.progress += amount;
        if (this.progress >= 50 && (charge = this.getCharge()) < 10) {
            this.setCharge(charge + 1);
            this.progress -= 50;
        }
        this.progress = MathHelper.func_76125_a((int)this.progress, (int)0, (int)50);
    }

    public void decrementProgress(int amount) {
        int charge;
        this.progress -= amount;
        if (this.progress < 0 && (charge = this.getCharge()) > 0) {
            this.setCharge(charge - 1);
            this.progress += 50;
        }
        this.progress = MathHelper.func_76125_a((int)this.progress, (int)0, (int)50);
    }

    public int getCharge() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksTW.COALESCENCE_MATRIX) {
            return state.func_177230_c().func_176201_c(state);
        }
        return 0;
    }

    public void setCharge(int amount) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == BlocksTW.COALESCENCE_MATRIX) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockCoalescenceMatrix.CHARGE, (Comparable)Integer.valueOf(amount)));
        }
    }

    public boolean isProgressFull() {
        return this.getCharge() >= 10 && this.progress >= 50;
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.progress = compound.func_74765_d("progress");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        compound.func_74777_a("progress", (short)this.progress);
        return compound;
    }

    public void func_73660_a() {
        ++this.tickCounter;
        if (!this.field_145850_b.field_72995_K && this.tickCounter % 20 == 0) {
            if (this.canMakeProgress()) {
                this.drainRifts();
            } else {
                this.decrementProgress(1);
            }
        }
    }

    protected void drainRifts() {
        List<EntityFluxRift> riftList = this.getValidRifts();
        boolean found = false;
        for (EntityFluxRift rift : riftList) {
            double drained = Math.sqrt(rift.getRiftSize());
            this.incrementProgress((int)drained);
            rift.setRiftStability(rift.getRiftStability() - (float)(drained / 15.0));
            if (this.field_145850_b.field_73012_v.nextInt(33) == 0) {
                rift.setRiftSize(rift.getRiftSize() - 1);
            }
            if (!(drained >= 1.0)) continue;
            found = true;
        }
        if (found) {
            this.syncTile(false);
            this.func_70296_d();
            if (this.tickCounter % 40 == 0) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 4, this.tickCounter);
            }
        }
    }

    protected List<EntityFluxRift> getValidRifts() {
        ArrayList<EntityFluxRift> retVal = new ArrayList<EntityFluxRift>();
        List riftList = EntityUtils.getEntitiesInRange((World)this.field_145850_b, (BlockPos)this.field_174879_c, null, EntityFluxRift.class, (double)16.0);
        for (EntityFluxRift rift : riftList) {
            if (rift.field_70128_L || rift.getRiftSize() <= 1) continue;
            Vec3d v1 = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            Vec3d v2 = new Vec3d(rift.field_70165_t, rift.field_70163_u, rift.field_70161_v);
            v1 = v1.func_178787_e(v2.func_178788_d(v1).func_72432_b());
            if (!EntityUtils.canEntityBeSeen((Entity)rift, (double)v1.field_72450_a, (double)v1.field_72448_b, (double)v1.field_72449_c)) continue;
            retVal.add(rift);
        }
        return retVal;
    }

    protected boolean canMakeProgress() {
        return this.isValidPlacement() && !this.isProgressFull() && this.getValidRifts().size() > 0;
    }

    protected boolean isValidPlacement() {
        int i;
        for (i = -2; i <= 2; ++i) {
            for (int k = -3; k <= 3; ++k) {
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(i, -1, k)).func_177230_c() == BlocksTC.stoneArcane) continue;
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-3, -1, i)).func_177230_c() != BlocksTC.stoneArcane) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(3, -1, i)).func_177230_c() == BlocksTC.stoneArcane) continue;
            return false;
        }
        for (i = -2; i <= 2; ++i) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(i, -1, -4)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(i, -1, 4)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-4, -1, i)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
                return false;
            }
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(4, -1, i)).func_177230_c() == BlocksTC.stoneArcaneBrick) continue;
            return false;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-3, -1, -3)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-3, -1, 3)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(3, -1, -3)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
            return false;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(3, -1, 3)).func_177230_c() != BlocksTC.stoneArcaneBrick) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-4, 0, -2)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-4, 0, 2)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(4, 0, -2)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(4, 0, 2)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 0, -4)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(-2, 0, 4)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 0, -4)).func_177230_c() instanceof BlockPillar)) {
            return false;
        }
        return this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(2, 0, 4)).func_177230_c() instanceof BlockPillar;
    }

    public boolean onCasterRightClick(World world, ItemStack stack, EntityPlayer player, BlockPos pos, EnumFacing facing, EnumHand hand) {
        if (this.getCharge() >= 10) {
            ArrayList<BlockPos> pillarList = new ArrayList<BlockPos>();
            pillarList.add(pos.func_177982_a(-4, 1, -2));
            pillarList.add(pos.func_177982_a(-4, 1, 2));
            pillarList.add(pos.func_177982_a(4, 1, -2));
            pillarList.add(pos.func_177982_a(4, 1, 2));
            pillarList.add(pos.func_177982_a(-2, 1, -4));
            pillarList.add(pos.func_177982_a(-2, 1, 4));
            pillarList.add(pos.func_177982_a(2, 1, -4));
            pillarList.add(pos.func_177982_a(2, 1, 4));
            if (this.field_145850_b.field_72995_K) {
                Color color = new Color(Aspect.FLUX.getColor());
                float r = (float)color.getRed() / 255.0f;
                float g = (float)color.getGreen() / 255.0f;
                float b = (float)color.getBlue() / 255.0f;
                for (BlockPos pillarPos : pillarList) {
                    FXDispatcher.INSTANCE.arcBolt((double)pillarPos.func_177958_n() + 0.5, (double)pillarPos.func_177956_o() + 1.0, (double)pillarPos.func_177952_p() + 0.5, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, r, g, b, 0.6f);
                }
            } else {
                world.func_184133_a(null, pos, SoundsTC.zap, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_175698_g(pos);
                world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2.0f, true);
                for (BlockPos pillarPos : pillarList) {
                    world.func_72876_a(null, (double)pillarPos.func_177958_n() + 0.5, (double)pillarPos.func_177956_o() + 0.5, (double)pillarPos.func_177952_p() + 0.5, 2.0f, true);
                }
                EntityCorruptionAvatar avatar = new EntityCorruptionAvatar(world);
                avatar.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextInt(360), 0.0f);
                world.func_72838_d((Entity)avatar);
            }
        }
        return true;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 4) {
            if (this.field_145850_b.field_72995_K) {
                List<EntityFluxRift> riftList = this.getValidRifts();
                for (EntityFluxRift rift : riftList) {
                    FXDispatcher.INSTANCE.voidStreak(rift.field_70165_t, rift.field_70163_u, rift.field_70161_v, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, type, 0.04f);
                }
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }
}

