/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thaumcraft.api.aura.AuraHelper;

public class TileEverburningUrn
extends TileTW
implements ITickable,
IFluidHandler {
    protected static final int CAPACITY = 1000;
    protected static final int MAX_PER_FILL = 40;
    protected int counter = 0;
    protected FluidTank tank = new FluidTank(new FluidStack(FluidRegistry.LAVA, 0), 1000);

    public FluidTank getTank() {
        return this.tank;
    }

    public void func_73660_a() {
        ++this.counter;
        if (!this.field_145850_b.field_72995_K && this.counter % 5 == 0 && this.tank.getFluidAmount() < 1000) {
            float actualVisDrain;
            int mbToAdd;
            float visToDrain = (float)(1000 - this.tank.getFluidAmount()) / 40.0f;
            if (visToDrain > 0.1f) {
                visToDrain = 0.1f;
            }
            if ((mbToAdd = (int)(40.0f * (actualVisDrain = AuraHelper.drainVis((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (float)visToDrain, (boolean)false)))) > 0) {
                this.tank.fill(new FluidStack(FluidRegistry.LAVA, mbToAdd), true);
                this.func_70296_d();
                if (this.tank.getFluidAmount() >= this.tank.getCapacity()) {
                    this.syncTile(false);
                }
            }
        }
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.tank.readFromNBT(compound);
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        this.tank.writeToNBT(compound);
        return compound;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        boolean wasFull = this.tank.getFluidAmount() >= this.tank.getCapacity();
        FluidStack fluidStack = this.tank.drain(resource, doDrain);
        this.func_70296_d();
        if (wasFull && this.tank.getFluidAmount() < this.tank.getCapacity()) {
            this.syncTile(false);
        }
        return fluidStack;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        boolean wasFull = this.tank.getFluidAmount() >= this.tank.getCapacity();
        FluidStack fluidStack = this.tank.drain(maxDrain, doDrain);
        this.func_70296_d();
        if (wasFull && this.tank.getFluidAmount() < this.tank.getCapacity()) {
            this.syncTile(false);
        }
        return fluidStack;
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return facing == EnumFacing.UP && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == EnumFacing.UP && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }
}

