/*
 * Decompiled with CFR 0.152.
 */
package com.verdantartifice.thaumicwonders.common.tiles.devices;

import com.verdantartifice.thaumicwonders.ThaumicWonders;
import com.verdantartifice.thaumicwonders.common.tiles.base.TileTW;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectHelper;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.entities.EntityFluxRift;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.EntityUtils;
import thaumcraft.common.lib.utils.RandomItemChooser;

public class TileVoidBeacon
extends TileTW
implements ITickable,
IAspectContainer,
IEssentiaTransport {
    private static final int CAPACITY = 100;
    private static final int PROGRESS_REQUIRED = 200;
    private static final int PLAY_EFFECTS = 4;
    private static final Map<Aspect, List<RandomItemChooser.Item>> REGISTRY = new HashMap<Aspect, List<RandomItemChooser.Item>>();
    private static final RandomItemChooser RIC = new RandomItemChooser();
    protected final List<BeamSegment> beamSegments = new ArrayList<BeamSegment>();
    protected Aspect essentiaType = null;
    protected int essentiaAmount = 0;
    protected int tickCounter = 0;
    protected boolean validPlacement = false;
    protected int levels = -1;
    protected int progress = 0;
    @SideOnly(value=Side.CLIENT)
    private long beamRenderCounter;
    @SideOnly(value=Side.CLIENT)
    private float beamRenderScale;

    @Nullable
    public Aspect getEssentiaType() {
        return this.essentiaType;
    }

    public int getEssentiaAmount() {
        return this.essentiaAmount;
    }

    public void clearEssentia() {
        this.essentiaType = null;
        this.essentiaAmount = 0;
        this.func_70296_d();
        this.syncTile(false);
    }

    public int getLevels() {
        return this.levels;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    protected void readFromTileNBT(NBTTagCompound compound) {
        this.essentiaType = Aspect.getAspect((String)compound.func_74779_i("essentiaType"));
        this.essentiaAmount = compound.func_74765_d("essentiaAmount");
        this.levels = compound.func_74765_d("levels");
        this.progress = compound.func_74765_d("progress");
    }

    @Override
    protected NBTTagCompound writeToTileNBT(NBTTagCompound compound) {
        if (this.essentiaType != null) {
            compound.func_74778_a("essentiaType", this.essentiaType.getTag());
            compound.func_74777_a("essentiaAmount", (short)this.essentiaAmount);
        }
        compound.func_74777_a("levels", (short)this.levels);
        compound.func_74777_a("progress", (short)this.progress);
        return compound;
    }

    public void func_73660_a() {
        ++this.tickCounter;
        if (!this.field_145850_b.field_72995_K && this.tickCounter % 5 == 0) {
            this.fill();
        }
        if (this.tickCounter % 80 == 0) {
            this.updateBeam();
            this.updateLevels();
        }
        if (!this.field_145850_b.field_72995_K && this.tickCounter % 20 == 0) {
            if (this.canMakeProgress()) {
                this.drainRifts();
            }
            while (this.canConjureItem()) {
                this.eject(this.getConjuredItem(this.essentiaType));
                this.progress -= 200;
                this.essentiaAmount -= this.getRequiredEssentia();
                if (this.essentiaAmount <= 0) {
                    this.essentiaType = null;
                }
                this.func_70296_d();
                this.syncTile(false);
            }
        }
    }

    protected boolean canMakeProgress() {
        return this.validPlacement && BlockStateUtils.isEnabled((int)this.func_145832_p()) && this.hasEnoughEssentia() && this.progress < 200;
    }

    protected boolean canConjureItem() {
        return this.validPlacement && BlockStateUtils.isEnabled((int)this.func_145832_p()) && this.hasEnoughEssentia() && this.canEject() && this.progress >= 200;
    }

    protected boolean hasEnoughEssentia() {
        if (this.essentiaType == null || this.levels < 0) {
            return false;
        }
        return this.essentiaAmount >= this.getRequiredEssentia();
    }

    protected int getRequiredEssentia() {
        switch (this.levels) {
            case 4: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 1: {
                return 10;
            }
        }
        return 20;
    }

    protected void eject(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            BlockPos otherPos = this.field_174879_c.func_177972_a(face);
            TileEntity te = this.field_145850_b.func_175625_s(otherPos);
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) continue;
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d());
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                if (!(stack = handler.insertItem(slot, stack, false)).func_190926_b()) continue;
                return;
            }
        }
        if (!stack.func_190926_b()) {
            ThaumicWonders.LOGGER.warn("Void beacon failed to eject {}!", (Object)stack);
        }
    }

    @Nonnull
    protected ItemStack getConjuredItem(Aspect aspect) {
        List<RandomItemChooser.Item> list = REGISTRY.get(aspect);
        if (list == null || list.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        RegistryEntry entry = (RegistryEntry)RIC.chooseOnWeight(list);
        if (entry == null) {
            return ItemStack.field_190927_a;
        }
        return entry.stack.func_77946_l();
    }

    protected boolean canEject() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            BlockPos otherPos = this.field_174879_c.func_177972_a(face);
            TileEntity te = this.field_145850_b.func_175625_s(otherPos);
            if (te == null || !te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d())) continue;
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.func_176734_d());
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                if (!handler.getStackInSlot(slot).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    protected void drainRifts() {
        List<EntityFluxRift> riftList = this.getValidRifts();
        boolean found = false;
        for (EntityFluxRift rift : riftList) {
            double drained = Math.sqrt(rift.getRiftSize());
            this.progress += (int)drained;
            rift.setRiftStability(rift.getRiftStability() - (float)(drained / 15.0));
            if (this.field_145850_b.field_73012_v.nextInt(33) == 0) {
                rift.setRiftSize(rift.getRiftSize() - 1);
            }
            if (!(drained >= 1.0)) continue;
            found = true;
        }
        if (found) {
            this.syncTile(false);
            this.func_70296_d();
            if (this.tickCounter % 40 == 0) {
                this.field_145850_b.func_175641_c(this.field_174879_c, this.func_145838_q(), 4, this.tickCounter);
            }
        }
    }

    protected List<EntityFluxRift> getValidRifts() {
        ArrayList<EntityFluxRift> retVal = new ArrayList<EntityFluxRift>();
        List riftList = EntityUtils.getEntitiesInRange((World)this.field_145850_b, (BlockPos)this.field_174879_c, null, EntityFluxRift.class, (double)16.0);
        for (EntityFluxRift rift : riftList) {
            if (rift.field_70128_L || rift.getRiftSize() <= 1) continue;
            Vec3d v1 = new Vec3d((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
            Vec3d v2 = new Vec3d(rift.field_70165_t, rift.field_70163_u, rift.field_70161_v);
            v1 = v1.func_178787_e(v2.func_178788_d(v1).func_72432_b());
            if (!EntityUtils.canEntityBeSeen((Entity)rift, (double)v1.field_72450_a, (double)v1.field_72448_b, (double)v1.field_72449_c)) continue;
            retVal.add(rift);
        }
        return retVal;
    }

    protected void updateBeam() {
        this.beamSegments.clear();
        this.validPlacement = true;
        Color beamColor = new Color(Aspect.ELDRITCH.getColor());
        BeamSegment segment = new BeamSegment(beamColor.getRGBColorComponents(null));
        this.beamSegments.add(segment);
        BlockPos.MutableBlockPos mbp = new BlockPos.MutableBlockPos();
        for (int y = this.field_174879_c.func_177956_o() + 1; y < this.field_145850_b.func_72940_L(); ++y) {
            mbp.func_181079_c(this.field_174879_c.func_177958_n(), y, this.field_174879_c.func_177952_p());
            IBlockState blockState = this.field_145850_b.func_180495_p((BlockPos)mbp);
            if (blockState.getLightOpacity((IBlockAccess)this.field_145850_b, (BlockPos)mbp) >= 15 && blockState.func_177230_c() != Blocks.field_150357_h) {
                this.validPlacement = false;
                this.beamSegments.clear();
                break;
            }
            segment.incrementHeight();
        }
    }

    protected void updateLevels() {
        this.levels = 0;
        if (this.validPlacement) {
            for (int yOffset = 1; yOffset <= 4 && this.isLevelComplete(yOffset); ++yOffset) {
                ++this.levels;
            }
        }
    }

    protected boolean isLevelComplete(int yOffset) {
        for (int x = this.field_174879_c.func_177958_n() - yOffset; x <= this.field_174879_c.func_177958_n() + yOffset; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - yOffset; z <= this.field_174879_c.func_177952_p() + yOffset; ++z) {
                int y = this.field_174879_c.func_177956_o() - yOffset;
                IBlockState state = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
                if (state.func_177230_c() == BlocksTC.metalBlockVoid) continue;
                return false;
            }
        }
        return true;
    }

    protected void fill() {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            Aspect type;
            IEssentiaTransport otherTile;
            TileEntity te;
            if (!this.canInputFrom(face) || this.getEssentiaAmount(face) >= 100 || (te = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (BlockPos)this.field_174879_c, (EnumFacing)face)) == null || !(te instanceof IEssentiaTransport) || !(otherTile = (IEssentiaTransport)te).canOutputTo(face.func_176734_d()) || (type = otherTile.getEssentiaType(face.func_176734_d())) == null || otherTile.getEssentiaAmount(face.func_176734_d()) <= 0 || this.getEssentiaType(face) != null && type != this.getEssentiaType(face) || this.getSuctionAmount(face) <= otherTile.getSuctionAmount(face.func_176734_d()) || this.getSuctionAmount(face) < otherTile.getMinimumSuction()) continue;
            int taken = otherTile.takeEssentia(type, 1, face.func_176734_d());
            int leftover = this.addToContainer(type, taken);
            if (leftover > 0) {
                ThaumicWonders.LOGGER.info("Void beacon spilling {} essentia on fill", (Object)leftover);
                AuraHelper.polluteAura((World)this.field_145850_b, (BlockPos)this.field_174879_c, (float)leftover, (boolean)true);
            }
            this.syncTile(false);
            this.func_70296_d();
        }
    }

    public int addEssentia(Aspect aspect, int amt, EnumFacing face) {
        if (this.canInputFrom(face) && (this.getEssentiaType(face) == null || aspect == this.getEssentiaType(face))) {
            return amt - this.addToContainer(aspect, amt);
        }
        return 0;
    }

    public boolean canInputFrom(EnumFacing face) {
        return face != EnumFacing.DOWN && face != EnumFacing.UP;
    }

    public boolean canOutputTo(EnumFacing face) {
        return false;
    }

    public int getEssentiaAmount(EnumFacing face) {
        return this.essentiaAmount;
    }

    public Aspect getEssentiaType(EnumFacing face) {
        return this.essentiaType;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(EnumFacing face) {
        return this.getEssentiaAmount(face) >= 100 ? 0 : 128;
    }

    public Aspect getSuctionType(EnumFacing face) {
        return this.getEssentiaType(face);
    }

    public boolean isConnectable(EnumFacing face) {
        return this.canInputFrom(face);
    }

    public void setSuction(Aspect aspect, int amt) {
    }

    public int takeEssentia(Aspect aspect, int amt, EnumFacing face) {
        return 0;
    }

    public int addToContainer(Aspect aspect, int toAdd) {
        int retVal = 0;
        if (toAdd == 0) {
            return 0;
        }
        if (this.essentiaAmount < 100 && (this.essentiaType == null || this.essentiaType == aspect)) {
            int added = Math.min(toAdd, 100 - this.essentiaAmount);
            this.essentiaAmount += added;
            this.essentiaType = aspect;
            retVal = toAdd - added;
        } else {
            retVal = toAdd;
        }
        this.func_70296_d();
        this.syncTile(false);
        return retVal;
    }

    public int containerContains(Aspect aspect) {
        return this.essentiaType == aspect ? this.essentiaAmount : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return true;
    }

    public boolean doesContainerContain(AspectList aspectList) {
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.doesContainerContainAmount(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amt) {
        return this.essentiaType == aspect && this.essentiaAmount >= amt;
    }

    public AspectList getAspects() {
        AspectList list = new AspectList();
        if (this.essentiaType != null) {
            list.add(this.essentiaType, this.essentiaAmount);
        }
        return list;
    }

    public void setAspects(AspectList aspectList) {
        if (aspectList != null && aspectList.size() > 0) {
            this.essentiaType = aspectList.getAspectsSortedByAmount()[0];
            this.essentiaAmount = aspectList.getAmount(this.essentiaType);
            this.func_70296_d();
            this.syncTile(false);
        }
    }

    public boolean takeFromContainer(AspectList aspectList) {
        if (!this.doesContainerContain(aspectList)) {
            return false;
        }
        boolean satisfied = true;
        for (Aspect aspect : aspectList.getAspects()) {
            satisfied = satisfied && this.takeFromContainer(aspect, aspectList.getAmount(aspect));
        }
        return satisfied;
    }

    public boolean takeFromContainer(Aspect aspect, int amt) {
        if (this.essentiaType == aspect && this.essentiaAmount >= amt) {
            this.essentiaAmount -= amt;
            if (this.essentiaAmount <= 0) {
                this.essentiaType = null;
            }
            this.func_70296_d();
            this.syncTile(false);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.beamSegments;
    }

    @SideOnly(value=Side.CLIENT)
    public float shouldBeamRender() {
        if (!this.validPlacement || !BlockStateUtils.isEnabled((int)this.func_145832_p())) {
            return 0.0f;
        }
        int i = (int)(this.field_145850_b.func_82737_E() - this.beamRenderCounter);
        this.beamRenderCounter = this.field_145850_b.func_82737_E();
        if (i > 1) {
            this.beamRenderScale -= (float)i / 40.0f;
            if (this.beamRenderScale < 0.0f) {
                this.beamRenderScale = 0.0f;
            }
        }
        this.beamRenderScale += 0.025f;
        if (this.beamRenderScale > 1.0f) {
            this.beamRenderScale = 1.0f;
        }
        return this.beamRenderScale;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 4) {
            if (this.field_145850_b.field_72995_K) {
                List<EntityFluxRift> riftList = this.getValidRifts();
                for (EntityFluxRift rift : riftList) {
                    FXDispatcher.INSTANCE.voidStreak(rift.field_70165_t, rift.field_70163_u, rift.field_70161_v, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, type, 0.04f);
                }
            }
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public static void initRegistry() {
        REGISTRY.clear();
        for (Aspect aspect : Aspect.aspects.values()) {
            REGISTRY.put(aspect, new ArrayList());
        }
    }

    public static void registerItemStack(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        stack = stack.func_77946_l();
        stack.func_190920_e(1);
        if (stack.func_77952_i() == Short.MAX_VALUE && stack.func_77973_b() instanceof ItemBlock) {
            ThaumicWonders.LOGGER.warn("Wildcard meta detected for {} in void beacon registration; this can result in invalid result blocks", (Object)stack);
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            for (IBlockState state : block.func_176194_O().func_177619_a()) {
                TileVoidBeacon.registerItemStackInternal(new ItemStack(stack.func_77973_b(), 1, block.func_176201_c(state)));
            }
        } else {
            TileVoidBeacon.registerItemStackInternal(stack);
        }
    }

    private static void registerItemStackInternal(@Nonnull ItemStack stack) {
        AspectList aspects = AspectHelper.getObjectAspects((ItemStack)stack);
        if (aspects != null) {
            for (Aspect aspect : aspects.getAspects()) {
                RegistryEntry entry = new RegistryEntry(stack, aspects.getAmount(aspect));
                List<RandomItemChooser.Item> list = REGISTRY.get(aspect);
                if (list == null || list.contains(entry)) continue;
                list.add(entry);
            }
        }
    }

    public static void registerOreDict(String oreDict) {
        List ores = ThaumcraftApiHelper.getOresWithWildCards((String)oreDict);
        if (ores != null && !ores.isEmpty()) {
            for (ItemStack ore : ores) {
                TileVoidBeacon.registerItemStack(ore);
            }
        }
    }

    public static class BeamSegment {
        private final float[] colors;
        private int height;

        public BeamSegment(float[] colorsIn) {
            this.colors = colorsIn;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        public float[] getColors() {
            return this.colors;
        }

        @SideOnly(value=Side.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }

    public static class RegistryEntry
    implements RandomItemChooser.Item {
        public ItemStack stack;
        public int weight;

        protected RegistryEntry(ItemStack stack, int weight) {
            this.stack = stack;
            this.weight = weight;
        }

        public double getWeight() {
            return this.weight;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof RegistryEntry)) {
                return false;
            }
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)((RegistryEntry)obj).stack);
        }

        public int hashCode() {
            return this.stack.hashCode();
        }
    }
}

