/*
 * Decompiled with CFR 0.152.
 */
package trinsdar.gravisuit.items.tools;

import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.block.machine.high.TileEntityTeleporter;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.base.BasicElectricItem;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import trinsdar.gravisuit.items.container.ItemInventoryRelocator;
import trinsdar.gravisuit.util.GravisuitLang;

public class ItemRelocator
extends BasicElectricItem
implements IHandHeldInventory {
    public ItemRelocator() {
        this.func_77655_b("relocator");
        this.setRegistryName("relocator");
        this.func_77637_a(IC2.tabIC2);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        if (IC2.platform.isSimulating()) {
            if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
                TeleportMode teleportMode = TeleportMode.values()[nbt.func_74771_c("TeleportMode")];
                teleportMode = teleportMode.getNext();
                nbt.func_74774_a("TeleportMode", (byte)teleportMode.ordinal());
                if (teleportMode == TeleportMode.PERSONAL) {
                    IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorPersonal);
                } else if (teleportMode == TeleportMode.PORTAL) {
                    IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorPortal);
                } else {
                    IC2.platform.messagePlayer(player, GravisuitLang.messageRelocatorTranslocator);
                }
            } else if (IC2.platform.isSimulating()) {
                NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
                if (nbt.func_74771_c("TeleportMode") == 0 || player.func_70093_af()) {
                    IC2.platform.launchGui(player, this.getInventory(player, handIn, player.func_184586_b(handIn)), handIn);
                }
            } else {
                return super.func_77659_a(worldIn, player, handIn);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, player, handIn);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        byte teleportMode = nbt.func_74771_c("TeleportMode");
        if (teleportMode == 0) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorPersonal}));
        } else if (teleportMode == 1) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorPortal}));
        } else if (teleportMode == 2) {
            tooltip.add(GravisuitLang.toolMode.getLocalizedFormatted(new Object[]{GravisuitLang.relocatorTranslocator}));
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), GravisuitLang.multiModes.getLocalized()}));
        tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gravisuit.wip", (Object[])new Object[0]));
    }

    public int getTextureEntry(int i) {
        return 179;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return 1.0E8;
    }

    public int getTier(ItemStack stack) {
        return 5;
    }

    public double getTransferLimit(ItemStack stack) {
        return 50000.0;
    }

    public boolean canUse(ItemStack stack, int energy) {
        return ElectricItem.manager.canUse(stack, (double)energy);
    }

    public void useEnergy(ItemStack stack, int energy, EntityPlayer player) {
        ElectricItem.manager.use(stack, (double)energy, (EntityLivingBase)player);
    }

    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    public IHasGui getInventory(EntityPlayer entityPlayer, EnumHand enumHand, ItemStack itemStack) {
        return new ItemInventoryRelocator(entityPlayer, this, itemStack, enumHand);
    }

    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData((ItemStack)stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData((ItemStack)stack).func_74768_a("GuiID", id);
    }

    public static void onButtonClick(ItemStack stack, int function, EntityPlayer player, TeleportData data) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        NBTTagCompound map = nbt.func_74775_l("Locations");
        if (function == 0) {
            NBTTagCompound tag = new NBTTagCompound();
            data.writeToNBT(tag);
            map.func_74782_a(data.getName(), (NBTBase)tag);
            nbt.func_74782_a("Locations", (NBTBase)map);
        }
    }

    public static void teleportEntity(EntityPlayer player, int x, int y, int z, int dimId, ItemStack stack) {
        boolean dimSwitch;
        double distance;
        int energyCost;
        int weight = TileEntityTeleporter.getWeightOfUser((Entity)player);
        if (weight != 0 && ElectricItem.manager.use(stack, (double)(energyCost = (int)((double)weight * Math.pow((distance = Math.sqrt(player.func_180425_c().func_177951_i((Vec3i)new BlockPos(x, y, z)))) + 10.0, (dimSwitch = player.field_70170_p.field_73011_w.getDimension() != dimId) ? 0.9 : 0.7) * 6.0)), (EntityLivingBase)player)) {
            player.func_184210_p();
            player.func_184226_ay();
            IC2.achievements.issueStat(player, "distanceTeleported", (int)distance);
            if (distance >= 1000.0) {
                IC2.achievements.issueStat(player, "teleportFarAway");
            }
            BlockPos targetPos = new BlockPos(x, y, z);
            if (!IC2.config.getFlag("TeleporterInventory")) {
                player.field_71071_by.func_70436_m();
            }
            if (dimSwitch) {
                player.func_70080_a((double)x, (double)y, (double)z, player.field_70177_z, player.field_70125_A);
            } else {
                player.func_70634_a((double)x, (double)y, (double)z);
            }
            if (dimSwitch) {
                TileEntityTeleporter.transferPlayerToDimension((EntityPlayerMP)((EntityPlayerMP)player), (int)dimId);
            }
        }
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    public static class TeleportData {
        int x;
        int y;
        int z;
        int dimId;
        String name;

        public TeleportData(int x, int y, int z, int dimId, String name) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimId = dimId;
            this.name = name;
        }

        public TeleportData(String name) {
            this.x = 0;
            this.y = 0;
            this.z = 0;
            this.dimId = 0;
            this.name = name;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public int getDimId() {
            return this.dimId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }

        public void setZ(int z) {
            this.z = z;
        }

        public void setDimId(int dimId) {
            this.dimId = dimId;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74780_a("X", (double)this.x);
            compound.func_74780_a("Y", (double)this.y);
            compound.func_74780_a("Z", (double)this.z);
            compound.func_74768_a("Dimension", this.dimId);
        }
    }

    public static enum TeleportMode {
        PERSONAL,
        PORTAL,
        TRANSLOCATOR;


        public TeleportMode getNext() {
            if (this == PERSONAL) {
                return PORTAL;
            }
            if (this == PORTAL) {
                return TRANSLOCATOR;
            }
            return PERSONAL;
        }
    }
}

