/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.entities.voidteleport.mixin;

import java.util.Arrays;
import java.util.List;
import mod.acgaming.universaltweaks.config.UTConfigTweaks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityLivingBase.class})
public abstract class UTVoidTeleportEntity {
    @Unique
    private static final String universalTweaks$combo = "universalTweaks$consecutiveVoidTeleportTimes";

    @Unique
    private static boolean isEnabledForDimension(int dimension) {
        List<String> list = Arrays.asList(UTConfigTweaks.ENTITIES.VOID_TELEPORT.utDimensionList);
        DimensionType dimensionType = DimensionManager.getProviderType((int)dimension);
        String dimensionName = dimensionType == null ? null : dimensionType.func_186065_b();
        boolean isWhitelist = UTConfigTweaks.ENTITIES.VOID_TELEPORT.utDimensionListMode == UTConfigTweaks.EnumLists.WHITELIST;
        return isWhitelist == (list.contains(dimensionName) || list.contains(String.valueOf(dimension)));
    }

    @Unique
    private static boolean isEnabledForEntity(Entity entity) {
        List<String> list = Arrays.asList(UTConfigTweaks.ENTITIES.VOID_TELEPORT.utEntityList);
        ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entity);
        if (resourceLocation == null) {
            return false;
        }
        boolean isWhitelist = UTConfigTweaks.ENTITIES.VOID_TELEPORT.utEntityListMode == UTConfigTweaks.EnumLists.WHITELIST;
        return list.contains(resourceLocation.toString()) == isWhitelist;
    }

    @Inject(method={"outOfWorld"}, at={@At(value="HEAD")}, cancellable=true)
    public void utTransferPlayerToDimension(CallbackInfo ci) {
        if (!UTConfigTweaks.ENTITIES.VOID_TELEPORT.utVoidTeleportToggle) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)this;
        if (!UTVoidTeleportEntity.isEnabledForDimension(entity.field_71093_bK)) {
            return;
        }
        if (UTConfigTweaks.ENTITIES.VOID_TELEPORT.utMaxCombo >= 0 && entity.getEntityData().func_74762_e(universalTweaks$combo) > UTConfigTweaks.ENTITIES.VOID_TELEPORT.utMaxCombo) {
            return;
        }
        if (UTConfigTweaks.ENTITIES.VOID_TELEPORT.utForgivePlayers && entity instanceof EntityPlayer || UTVoidTeleportEntity.isEnabledForEntity((Entity)entity)) {
            int highestClearLocation;
            if (UTConfigTweaks.ENTITIES.VOID_TELEPORT.utPreventVoidDamage) {
                ci.cancel();
            }
            if (UTConfigTweaks.ENTITIES.VOID_TELEPORT.utTeleportBlindness) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60, 3));
            }
            int targetY = UTConfigTweaks.ENTITIES.VOID_TELEPORT.utTargetYLevel < (highestClearLocation = entity.func_130014_f_().func_189649_b(MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70161_v))) ? highestClearLocation : UTConfigTweaks.ENTITIES.VOID_TELEPORT.utTargetYLevel;
            entity.func_70634_a(entity.field_70165_t, (double)targetY, entity.field_70161_v);
            entity.field_70181_x = Math.min(0.0, Math.max(UTConfigTweaks.ENTITIES.VOID_TELEPORT.utClampSpeedTo, entity.field_70181_x));
            if (entity.getEntityData().func_74764_b(universalTweaks$combo)) {
                entity.getEntityData().func_74768_a(universalTweaks$combo, entity.getEntityData().func_74762_e(universalTweaks$combo) + 1);
            } else {
                entity.getEntityData().func_74768_a(universalTweaks$combo, 1);
            }
        }
    }

    @Inject(method={"updateFallState"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;updateFallState(DZLnet/minecraft/block/state/IBlockState;Lnet/minecraft/util/math/BlockPos;)V")})
    public void utUpdateFallState(double y, boolean onGroundIn, IBlockState state, BlockPos pos, CallbackInfo ci) {
        if (!UTConfigTweaks.ENTITIES.VOID_TELEPORT.utVoidTeleportToggle) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)this;
        if (onGroundIn && entity.getEntityData().func_74764_b(universalTweaks$combo)) {
            entity.getEntityData().func_82580_o(universalTweaks$combo);
            if (entity.func_70090_H()) {
                return;
            }
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).field_71075_bZ.field_75100_b || ((EntityPlayer)entity).field_71075_bZ.field_75101_c)) {
                return;
            }
            if (UTConfigTweaks.ENTITIES.VOID_TELEPORT.utFallHeight < 0.0f) {
                entity.field_70143_R = 0.0f;
                float setting = UTConfigTweaks.ENTITIES.VOID_TELEPORT.utFallDamageTaken;
                if (setting != 0.0f) {
                    float damage;
                    float f = damage = setting < 0.0f ? entity.func_110138_aP() + setting : setting;
                    if (!UTConfigTweaks.ENTITIES.VOID_TELEPORT.utAllowSpecificFallDamageToKill) {
                        damage = Float.min(entity.func_110143_aJ() - 1.0f, damage);
                    }
                    if (damage > 0.0f) {
                        entity.func_184185_a(SoundEvents.field_187655_bw, 1.0f, 1.0f);
                        entity.func_70097_a(DamageSource.field_76379_h, damage);
                    }
                }
            } else {
                entity.field_70143_R = UTConfigTweaks.ENTITIES.VOID_TELEPORT.utFallHeight;
            }
        }
    }
}

