/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.tweaks.performance.craftingcache;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import mod.acgaming.universaltweaks.UniversalTweaks;
import mod.acgaming.universaltweaks.config.UTConfigGeneral;
import mod.acgaming.universaltweaks.tweaks.performance.craftingcache.UTCraftMatrixCacheKey;
import mod.acgaming.universaltweaks.tweaks.performance.craftingcache.UTOptionalContent;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class UTCraftingCache {
    private static final Int2ObjectLinkedOpenHashMap<UTOptionalContent<IRecipe>> NON_NBT_CRAFT_CACHE = new Int2ObjectLinkedOpenHashMap();
    private static final boolean isIC2ClassicLoaded = Loader.isModLoaded((String)"ic2-classic-spmod");
    private static IRecipe lastMatchingRecipe = null;

    public static void resetCache() {
        NON_NBT_CRAFT_CACHE.clear();
        lastMatchingRecipe = null;
    }

    public static boolean isValid(InventoryCrafting craftMatrix) {
        for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
            ItemStack itemStack = craftMatrix.func_70301_a(i);
            if (itemStack.func_77942_o()) {
                return false;
            }
            if (!isIC2ClassicLoaded || itemStack.func_190916_E() <= 1) continue;
            return false;
        }
        return true;
    }

    public static IRecipe findMatchingRecipeDefault(InventoryCrafting craftMatrix, World worldIn) {
        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            if (!irecipe.func_77569_a(craftMatrix, worldIn)) continue;
            lastMatchingRecipe = irecipe;
            return irecipe;
        }
        return null;
    }

    public static IRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World worldIn) {
        if (Loader.instance().hasReachedState(LoaderState.SERVER_STARTING)) {
            IRecipe previousMatch = lastMatchingRecipe;
            if (previousMatch != null && previousMatch.func_77569_a(craftMatrix, worldIn)) {
                return previousMatch;
            }
            if (UTCraftingCache.isValid(craftMatrix)) {
                IRecipe recipe;
                UTOptionalContent<IRecipe> optionalContent = UTCraftingCache.getOrCreateCachedRecipe(craftMatrix);
                if (optionalContent.hasContent() && ((recipe = optionalContent.getContent()) == null || recipe.func_77569_a(craftMatrix, worldIn))) {
                    lastMatchingRecipe = recipe;
                    return recipe;
                }
                recipe = UTCraftingCache.findMatchingRecipeDefault(craftMatrix, worldIn);
                optionalContent.setContent(recipe);
                return recipe;
            }
        }
        return UTCraftingCache.findMatchingRecipeDefault(craftMatrix, worldIn);
    }

    public static synchronized UTOptionalContent<IRecipe> getOrCreateCachedRecipe(InventoryCrafting craftMatrix) {
        UTCraftMatrixCacheKey matrixKey = new UTCraftMatrixCacheKey(craftMatrix);
        UTOptionalContent<IRecipe> optionalContent = (UTOptionalContent<IRecipe>)NON_NBT_CRAFT_CACHE.getAndMoveToFirst(matrixKey.hashCode());
        if (optionalContent == null) {
            optionalContent = new UTOptionalContent<IRecipe>();
            NON_NBT_CRAFT_CACHE.putAndMoveToFirst(matrixKey.hashCode(), optionalContent);
        }
        if (UTConfigGeneral.DEBUG.utDebugToggle) {
            UniversalTweaks.LOGGER.debug("Recipe HashCode: " + matrixKey.hashCode());
        }
        return optionalContent;
    }
}

