/*
 * Decompiled with CFR 0.152.
 */
package xjon.developercapes.cape;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import xjon.developercapes.DevCapes;
import xjon.developercapes.cape.ICape;
import xjon.developercapes.cape.StaticCape;

public class CapeManager {
    protected static CapeManager instance;
    private HashMap<String, ICape> capes = new HashMap();

    public static CapeManager getInstance() {
        if (instance == null) {
            instance = new CapeManager();
        }
        return instance;
    }

    public void addCape(ICape cape) {
        if (!this.capes.containsValue(cape)) {
            this.capes.put(cape.getName(), cape);
        }
    }

    public void addCapes(Collection<ICape> capes) {
        for (ICape c : capes) {
            this.addCape(c);
        }
    }

    public ICape getCape(String capeName) {
        return this.capes.get(capeName);
    }

    public ICape newCape(String name) {
        StaticCape cape = new StaticCape(name);
        this.capes.put(name, cape);
        return cape;
    }

    public ICape parse(String name, Object object) {
        ICape cape = null;
        if (object instanceof String || object instanceof URL) {
            cape = this.parse(name, object.toString());
        } else {
            DevCapes.logger.error(String.format("Cape, %s, could not be parsed because it is not in an accepted format!", object));
        }
        return cape;
    }

    protected ICape parse(String name, String url) {
        StaticCape cape = null;
        try {
            cape = new StaticCape(name, new URL(url));
        }
        catch (MalformedURLException e) {
            DevCapes.logger.error(String.format("Are you crazy?? \"%s\" is not a valid URL!", url));
            e.printStackTrace();
        }
        return cape;
    }
}

