/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.block.tile;

import ic2.api.energy.prefab.BasicSource;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.info.ILocatable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.common.lib.events.EssentiaHandler;

public class EssentiaGeneratorBase
extends TileEntity
implements ITickable,
IEnergySource,
ILocatable {
    private String BURN_TIME_NBT_KEY;
    int pulseTimer = 20;
    private int fade = 0;
    private BasicSource energySource;
    private Aspect aspect;

    public EssentiaGeneratorBase(int essentia) {
        this.aspect = essentia == 1 ? Aspect.AIR : (essentia == 2 ? Aspect.AURA : (essentia == 3 ? Aspect.FIRE : Aspect.ENERGY));
        this.energySource = new BasicSource((ILocatable)this, 1.0E8, 3);
    }

    public void func_73660_a() {
        if (this.pulseTimer <= 0) {
            double energy = 0.0;
            int range = 4;
            int start = -4;
            block2: for (int aa = -range; aa <= range; ++aa) {
                for (int bb = -range; bb <= range; ++bb) {
                    for (int cc = start; cc < range; ++cc) {
                        if (aa == 0 && bb == 0 && cc == 0) continue;
                        if (this.energySource.getFreeCapacity() < 65.0) break block2;
                        int xx = this.field_174879_c.func_177958_n() + aa;
                        int yy = this.field_174879_c.func_177956_o() + cc;
                        int zz = this.field_174879_c.func_177952_p() + bb;
                        TileEntity te = null;
                        try {
                            te = this.field_145850_b.func_175625_s(new BlockPos(xx, yy, zz));
                        }
                        catch (Error error) {
                            // empty catch block
                        }
                        if (!(te instanceof IAspectSource) || !((IAspectSource)te).doesContainerContainAmount(this.aspect, 1) || ((IAspectSource)te).isBlocked()) continue;
                        ((IAspectSource)te).takeFromContainer(this.aspect, 1);
                        energy += 66.66666666;
                        this.fade = 40;
                        String key = System.currentTimeMillis() + ":" + this.field_174879_c.func_177958_n() + ":" + this.field_174879_c.func_177956_o() + ":" + this.field_174879_c.func_177952_p() + ":" + xx + ":" + yy + ":" + zz + ":" + this.aspect.getColor();
                        EssentiaHandler.sourceFX.put(key, new EssentiaHandler.EssentiaSourceFX(this.field_174879_c, new BlockPos(xx, yy, zz), this.aspect.getColor(), 1));
                    }
                }
            }
            this.energySource.addEnergy(energy);
            this.pulseTimer = 20;
        } else {
            --this.pulseTimer;
            if (this.fade > 0) {
                --this.fade;
            }
        }
    }

    public Aspect getAspect() {
        return this.aspect;
    }

    public int getFade() {
        return this.fade;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energySource.readFromNBT(compound);
        this.pulseTimer = compound.func_74771_c(this.BURN_TIME_NBT_KEY);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74774_a(this.BURN_TIME_NBT_KEY, (byte)this.pulseTimer);
        this.energySource.writeToNBT(compound);
        return super.func_189515_b(compound);
    }

    public void onLoad() {
        super.onLoad();
        this.energySource.onLoad();
    }

    public void func_145843_s() {
        this.energySource.invalidate();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.energySource.onChunkUnload();
        super.onChunkUnload();
    }

    public double getOfferedEnergy() {
        return Math.max(this.energySource.getOfferedEnergy(), 32768.0);
    }

    public void drawEnergy(double amount) {
        this.energySource.drawEnergy(amount);
    }

    public int getSourceTier() {
        return 3;
    }

    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    public BlockPos getPosition() {
        return this.field_174879_c;
    }

    public World getWorldObj() {
        return this.field_145850_b;
    }
}

