/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.crops;

import ic2.api.crops.CropCard;
import ic2.api.crops.CropProperties;
import ic2.api.crops.ICropTile;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import weissmoon.core.helper.RNGHelper;

public class QuicksilverCrop
extends CropCard {
    public String getId() {
        return "quickislver";
    }

    public String getOwner() {
        return "welectromagic";
    }

    public CropProperties getProperties() {
        return new CropProperties(7, 5, 0, 8, 2, 3);
    }

    public int getMaxSize() {
        return 5;
    }

    public ItemStack getGain(ICropTile crop) {
        int gain = crop.getStatGain();
        float chance = RNGHelper.getRNGFloat().floatValue() * 10.0f;
        if (chance > (float)(gain + 1)) {
            return new ItemStack(ItemsTC.quicksilver);
        }
        int resistance = crop.getStatResistance();
        if (chance < (float)gain) {
            float amount = ((float)resistance / 10.0f + RNGHelper.getRNGFloat().floatValue()) * 4.0f;
            return new ItemStack(BlocksTC.shimmerleaf, (int)amount);
        }
        return ItemStack.field_190927_a;
    }

    public int getSizeAfterHarvest(ICropTile cropTile) {
        return 2;
    }

    public int getEmittedLight(ICropTile crop) {
        if (crop.getCurrentSize() == 5) {
            return 8;
        }
        if (crop.getCurrentSize() < 2) {
            return 5;
        }
        return 0;
    }

    public List<ResourceLocation> getTexturesLocation() {
        return null;
    }

    public String getDiscoveredBy() {
        return "Azanor";
    }

    public boolean onRightClick(ICropTile cropTile, EntityPlayer player) {
        SPacketSoundEffect packet = new SPacketSoundEffect(new SoundEvent(new ResourceLocation("thaumcraft:whispers")), SoundCategory.AMBIENT, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f);
        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)packet);
        return cropTile.performManualHarvest();
    }
}

