/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.event;

import baubles.api.BaublesApi;
import com.google.common.collect.Lists;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSoundEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.logging.log4j.Level;
import thaumcraft.api.capabilities.IPlayerKnowledge;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import weissmoon.core.utils.LogHelper;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.advancements.BaubleHitTrigger;
import weissmoon.electromagictools.advancements.WingDeathTrigger;
import weissmoon.electromagictools.item.ModItems;
import weissmoon.electromagictools.item.armour.boots.ItemNanoBootsTraveller;
import weissmoon.electromagictools.item.armour.boots.ItemQuantumBootsTraveller;
import weissmoon.electromagictools.item.armour.wings.ItemFeatherWings;
import weissmoon.electromagictools.item.armour.wings.ItemNanoWings;
import weissmoon.electromagictools.item.armour.wings.ItemQuantumWings;
import weissmoon.electromagictools.network.OverrideScanPacket;
import weissmoon.electromagictools.network.PacketHandler;

public class EventPool {
    private SoundEvent sound = new SoundEvent(new ResourceLocation("welectromagic:hitcancel"));

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            IPlayerKnowledge knowledge = ThaumcraftCapabilities.getKnowledge((EntityPlayer)event.player);
            if (ElectroMagicTools.ic2ceLoaded ? !knowledge.addResearch("p_ic2c_extras") : !knowledge.removeResearch("p_ic2c_extras")) {
                return;
            }
            knowledge.sync((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDeath(LivingDeathEvent event) {
        EntityPlayer player;
        int slot;
        if (event.getEntity() instanceof EntityPlayer && (slot = BaublesApi.isBaubleEquipped((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()), (Item)ModItems.hitBauble)) != -1 && event.getSource().field_76373_n.matches("infinity")) {
            event.setCanceled(true);
            return;
        }
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntityLiving().getEntityData().func_82580_o("WEMTMindCorruption");
        }
        if (event.getSource() == DamageSource.field_76379_h && event.getEntityLiving() instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)event.getEntityLiving();
            ItemStack stack = ItemStack.field_190927_a;
            ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack bodyStack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
            if (chestStack.func_77973_b() instanceof ItemFeatherWings || bodyStack.func_77973_b() instanceof ItemFeatherWings) {
                stack = chestStack == ItemStack.field_190927_a || !(chestStack.func_77973_b() instanceof ItemFeatherWings) ? bodyStack : (bodyStack == ItemStack.field_190927_a || !(bodyStack.func_77973_b() instanceof ItemFeatherWings) ? chestStack : (((ItemFeatherWings)chestStack.func_77973_b()).getTier() > ((ItemFeatherWings)chestStack.func_77973_b()).getTier() ? chestStack : bodyStack));
            }
            if (stack.func_77973_b() instanceof ItemFeatherWings) {
                WingDeathTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobDrop(LivingDropsEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityCreeper && ((EntityCreeper)entity).func_70830_n()) {
            EntityItem item = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            item.func_92058_a(new ItemStack((Item)ModItems.materials, 1, 1));
            event.getDrops().add(item);
        }
    }

    @SubscribeEvent
    public void onNanoBootsFall(LivingFallEvent event) {
        PotionEffect potioneffect = event.getEntityLiving().func_70660_b(MobEffects.field_76430_j);
        float f = potioneffect == null ? 0.0f : (float)(potioneffect.func_76458_c() + 1);
        int i = MathHelper.func_76123_f((float)((event.getDistance() - 3.0f - f) * event.getDamageMultiplier()));
        if (i > 0) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
            if (stack.func_77973_b() instanceof ItemNanoBootsTraveller && ElectricItem.manager.use(stack, (double)((ItemNanoBootsTraveller)stack.func_77973_b()).getEnergyPerDamage(), (EntityLivingBase)player)) {
                event.setCanceled(true);
            }
            if (event.isCanceled()) {
                if (stack.func_77973_b() instanceof ItemQuantumBootsTraveller) {
                    ((ItemQuantumBootsTraveller)stack.func_77973_b()).damageAbsorbed(player, i);
                }
                return;
            }
            ItemStack chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST);
            ItemStack bodyStack = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
            if (chestStack.func_77973_b() instanceof ItemFeatherWings || bodyStack.func_77973_b() instanceof ItemFeatherWings) {
                stack = chestStack == ItemStack.field_190927_a || !(chestStack.func_77973_b() instanceof ItemFeatherWings) ? bodyStack : (bodyStack == ItemStack.field_190927_a || !(bodyStack.func_77973_b() instanceof ItemFeatherWings) ? chestStack : (((ItemFeatherWings)chestStack.func_77973_b()).getTier() > ((ItemFeatherWings)chestStack.func_77973_b()).getTier() ? chestStack : bodyStack));
            }
            if (stack.func_77973_b() instanceof ItemFeatherWings) {
                if (stack.func_77973_b() instanceof IElectricItem && ElectricItem.manager.use(stack, (double)((ItemNanoWings)stack.func_77973_b()).getEnergyPerDamage(), (EntityLivingBase)player)) {
                    if (stack.func_77973_b() instanceof ItemQuantumWings) {
                        event.setCanceled(true);
                        return;
                    }
                    return;
                }
                float mult = event.getDamageMultiplier();
                event.setDamageMultiplier(mult /= ((ItemFeatherWings)stack.func_77973_b()).getFallDamage());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDamaged(LivingDamageEvent event) {
        ItemStack bauble;
        EntityPlayer player;
        int slot;
        if (event.getEntityLiving() instanceof EntityPlayerMP && (slot = BaublesApi.isBaubleEquipped((EntityPlayer)(player = (EntityPlayer)event.getEntityLiving()), (Item)ModItems.hitBauble)) != -1 && NBTHelper.getInt((ItemStack)(bauble = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(slot)), (String)"charge") >= 200) {
            event.setCanceled(true);
            NBTHelper.setInteger((ItemStack)bauble, (String)"charge", (int)0);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSoundEffect(this.sound, SoundCategory.PLAYERS, player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0f, 1.0f));
                if (event.getAmount() >= 50.0f) {
                    BaubleHitTrigger.INSTANCE.trigger((EntityPlayerMP)player, bauble);
                }
            }
        }
    }

    @SubscribeEvent
    public void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().field_72995_K && event.getEntityPlayer() != null) {
            List list;
            event.getEntityPlayer().func_184600_cs();
            ItemStack heldItem = event.getEntityPlayer().func_184586_b(event.getEntityPlayer().func_184600_cs());
            if (!heldItem.func_190926_b() && (list = EnumInfusionEnchantment.getInfusionEnchantments((ItemStack)heldItem)).contains(EnumInfusionEnchantment.SOUNDING) && event.getEntityPlayer().func_70093_af()) {
                heldItem.func_77972_a(5, (EntityLivingBase)event.getEntityPlayer());
                event.getWorld().func_184148_a(null, (double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.5, (double)event.getPos().func_177952_p() + 0.5, SoundsTC.wandfail, SoundCategory.BLOCKS, 0.2f, 0.2f + event.getWorld().field_73012_v.nextFloat() * 0.2f);
                PacketHandler.INSTANCE.sendTo((IMessage)new OverrideScanPacket(event.getPos(), EnumInfusionEnchantment.getInfusionEnchantmentLevel((ItemStack)heldItem, (EnumInfusionEnchantment)EnumInfusionEnchantment.SOUNDING)), (EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public void onEntitySpawn(EntityJoinWorldEvent event) {
        EntityItem item;
        if (event.getEntity() instanceof EntityItem && (item = (EntityItem)event.getEntity()).func_92059_d().func_77973_b().equals(ModItems.onering)) {
            item.func_184224_h(true);
            item.func_174873_u();
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool;
        ArrayList entries = Lists.newArrayList();
        ArrayList conditions = Lists.newArrayList();
        ArrayList functions = Lists.newArrayList();
        RandomValueRange rolls = new RandomValueRange(1.0f);
        RandomValueRange bonusRolls = new RandomValueRange(0.0f, 0.0f);
        if (event.getName().toString().matches("minecraft:chests/spawn_bonus_chest")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), rolls, bonusRolls, "onering");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.onering, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/desert_pyramid")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.25f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/igloo_chest")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), rolls, bonusRolls, "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/jungle_temple")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.25f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/simple_dungeon")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.5f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/stronghold_corridor")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.15f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/stronghold_crossing")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.15f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.stormCaster, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
        if (event.getName().toString().matches("minecraft:chests/end_city_treasure")) {
            pool = new LootPool(entries.toArray(new LootEntry[0]), conditions.toArray(new LootCondition[0]), new RandomValueRange(0.0f, 0.0f), new RandomValueRange(0.0f, 0.5f), "mjolnir");
            pool.addEntry((LootEntry)new LootEntryItem((Item)ModItems.mj\u00f6lnir, 1, 1, functions.toArray(new LootFunction[0]), conditions.toArray(new LootCondition[0]), "mjolnir"));
            event.getTable().addPool(pool);
            LogHelper.log((String)"welectromagic", (Level)Level.INFO, (Object)("Injecting Mj\u00f6lnir into LootTable: \"" + event.getName().toString() + "\""));
        }
    }
}

