/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.googles;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.classic.item.IElectricTool;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.entity.IC2DamageSource;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.items.IGoggles;
import thaumcraft.api.items.IVisDiscountGear;
import weissmoon.core.item.armour.ItemArmourBase;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemElectricGoggles
extends ItemArmourBase
implements IDamagelessElectricItem,
IVisDiscountGear,
IGoggles,
IMetalArmor,
ISpecialArmor,
IElectricTool {
    protected int tier;
    protected int energyPerDamage;
    protected int visDiscount;
    protected int maxCharge;
    protected int transferLimit;

    public ItemElectricGoggles() {
        this("itemElectricGoggles", ItemArmor.ArmorMaterial.IRON, 10000, 100, 1, 500, 4);
    }

    protected ItemElectricGoggles(String name, ItemArmor.ArmorMaterial material, int maxCharge, int transferLimit, int tier, int energyPerDamage, int visDiscount) {
        super(name, material, 0, EntityEquipmentSlot.HEAD);
        this.setNoRepair();
        this.func_77656_e(0);
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
        this.maxCharge = maxCharge;
        this.transferLimit = transferLimit;
        this.tier = tier;
        this.energyPerDamage = energyPerDamage;
        this.visDiscount = visDiscount;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/electricarmour.png";
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{ElectroMagicTools.EMTtab, CreativeTabs.field_78037_j};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean showIngamePopups(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    public int getVisDiscount(ItemStack stack, EntityPlayer player) {
        return this.visDiscount;
    }

    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, @Nonnull DamageSource source, double damage, int slot) {
        if (source.func_76363_c() && !this.isBlockingEverything()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        if (source.func_76355_l().equals(IC2DamageSource.electricity.func_76355_l()) && IC2.config.getFlag("SpecialElectricArmor")) {
            return !ItemElectricArmorBase.hasElectricBoots((EntityLivingBase)player) ? new ISpecialArmor.ArmorProperties(0, 1.0, this.maxCharge - (int)ElectricItem.manager.getCharge(armor)) : new ISpecialArmor.ArmorProperties(0, 1.0, Integer.MAX_VALUE);
        }
        double absorptionRatio = 0.15 * this.getAbsorptionRatio();
        double energyPerDamage = this.energyPerDamage;
        int damageLimit = (int)(energyPerDamage > 0.0 ? ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (energyPerDamage *= (double)IC2.config.getFloat("electricSuitEnergyCostModifier")) : 0.0);
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio *= (double)IC2.config.getFloat("electricSuitAbsorbtionScale"), damageLimit);
    }

    public boolean isBlockingEverything() {
        return false;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (ElectricItem.manager.getCharge(armor) >= (double)this.energyPerDamage) {
            return (int)Math.round(3.0 * this.getAbsorptionRatio());
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        ElectricItem.manager.discharge(stack, (double)(damage * this.energyPerDamage), Integer.MAX_VALUE, true, false, false);
    }

    protected double getAbsorptionRatio() {
        return 0.5;
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.ARMOR_HEAD;
    }

    public boolean isSpecialSupported(ItemStack itemStack, Enchantment enchantment) {
        return false;
    }

    public boolean isExcluded(ItemStack item, Enchantment ench) {
        return ench == Enchantments.field_92091_k || ench == Enchantments.field_185296_A;
    }
}

