/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.googles;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.item.IThermometer;
import ic2.api.item.IElectricItem;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.IRarity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.item.armour.googles.ItemElectricGoggles;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemNanoGoggles
extends ItemElectricGoggles
implements IEUReader,
IThermometer,
ICropAnalyzer {
    public ItemNanoGoggles() {
        super("itemNanoGoggles", ItemArmor.ArmorMaterial.IRON, 100000, 1600, 2, 800, 6);
    }

    public ItemNanoGoggles(String name, ItemArmor.ArmorMaterial material, int maxCharge, int transferLimit, int tier, int energyPerDamage, int visDiscount) {
        super(name, material, maxCharge, transferLimit, tier, energyPerDamage, visDiscount);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean shift;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        if ((nbt.func_74764_b("EUReaderUpgrade") || nbt.func_74764_b("CropUpgrade") || nbt.func_74764_b("ThermometerUpgrade")) && (shift = Ic2Lang.isShiftDown(tooltip))) {
            if (nbt.func_74764_b("EUReaderUpgrade")) {
                tooltip.add(Ic2Lang.upgradeEU.getLocalized());
            }
            if (nbt.func_74764_b("CropUpgrade")) {
                tooltip.add(Ic2Lang.upgradeCrop.getLocalized());
            }
            if (nbt.func_74764_b("ThermometerUpgrade")) {
                tooltip.add(Ic2Lang.upgradeThermo.getLocalized());
            }
        }
    }

    public IRarity getForgeRarity(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/nanoarmour.png";
    }

    @Override
    public double getAbsorptionRatio() {
        return 0.9;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
            ItemStack full = ItemHelper.getChargedItem((IElectricItem)this, 1);
            NBTHelper.setBoolean((ItemStack)full, (String)"CropUpgrade", (boolean)true);
            NBTHelper.setBoolean((ItemStack)full, (String)"EUReaderUpgrade", (boolean)true);
            NBTHelper.setBoolean((ItemStack)full, (String)"ThermometerUpgrade", (boolean)true);
            list.add((Object)full);
        }
    }

    public boolean isCropAnalyzer(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("CropUpgrade");
    }

    public boolean isEUReader(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("EUReaderUpgrade");
    }

    public boolean isThermometer(ItemStack stack) {
        return StackUtil.getNbtData((ItemStack)stack).func_74767_n("ThermometerUpgrade");
    }
}

