/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.armour.wings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import baubles.api.render.IRenderBauble;
import ic2.api.util.Keys;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.item.armour.ItemArmourBase;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.client.WingsModelRenderer;
import weissmoon.electromagictools.item.ModItems;

public class ItemFeatherWings
extends ItemArmourBase
implements IBauble,
IRenderBauble {
    protected float fallReduction;
    protected float fallDamage;
    protected float propulsion;
    protected int tier;
    protected SoundEvent sound = new SoundEvent(new ResourceLocation("welectromagic:wingflap"));
    @SideOnly(value=Side.CLIENT)
    protected WingsModelRenderer model;

    public ItemFeatherWings() {
        this("itemFeatherWings", ItemArmor.ArmorMaterial.LEATHER);
        this.fallReduction = 0.9f;
        this.fallDamage = 0.75f;
        this.propulsion = 0.11f;
        this.func_77656_e(120);
        this.tier = 0;
    }

    protected ItemFeatherWings(String name, ItemArmor.ArmorMaterial materialIn) {
        super(name, materialIn, 0, EntityEquipmentSlot.CHEST);
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped original) {
        if (this.model == null) {
            this.model = new WingsModelRenderer(new ItemStack((Item)ModItems.materials, 1, 7), 0);
        }
        return this.model;
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "welectromagic:textures/models/armor/empty.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        this.tickWings(player, stack, world);
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{ElectroMagicTools.EMTtab, CreativeTabs.field_78037_j};
    }

    public void tickWings(@Nonnull EntityPlayer player, ItemStack wings, World world) {
        boolean falling = !player.field_70122_E && player.field_70181_x < 0.0;
        byte flap = NBTHelper.getByte((ItemStack)wings, (String)"flap");
        if (Keys.instance.isJumpKeyDown(player)) {
            if (flap < 7) {
                flap = (byte)(flap + 1);
                NBTHelper.setByte((ItemStack)wings, (String)"flap", (byte)flap);
            }
            if (falling) {
                player.field_70181_x *= (double)this.fallReduction;
            }
            player.field_70143_R = 0.0f;
        } else if (flap > 0) {
            player.field_70181_x = this.propulsion * (float)flap;
            world.func_184148_a(player, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.sound, SoundCategory.PLAYERS, 0.5f, 1.0f);
            NBTHelper.setByte((ItemStack)wings, (String)"flap", (byte)0);
            player.field_70143_R = 0.0f;
        }
        if (!player.func_184812_l_()) {
            if (player.func_70090_H()) {
                player.field_70181_x -= 0.028;
            }
            if (world.func_175727_C(player.func_180425_c())) {
                player.field_70181_x -= 0.035;
            }
        }
        if (Keys.instance.isSneakKeyDown(player) && falling) {
            player.field_70181_x *= 0.6;
            player.field_70143_R = 0.0f;
        }
    }

    public final int getTier() {
        return this.tier;
    }

    public float getFallDamage() {
        return this.fallDamage;
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.BODY;
    }

    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (player instanceof EntityPlayer) {
            this.tickWings((EntityPlayer)player, itemstack, player.field_70170_p);
        }
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.BODY) {
            ((WingsModelRenderer)this.getArmorModel((EntityLivingBase)player, stack, null, null)).renderB(stack, player, type, partialTicks);
        }
    }
}

