/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.block;

import ic2.core.platform.player.PlayerHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.api.client.item.IItemRenderCustom;
import weissmoon.core.api.client.item.IItemRenderer;
import weissmoon.core.client.render.IIcon;
import weissmoon.core.client.render.IIconRegister;
import weissmoon.core.item.WeissItemBlock;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.block.ModBlocks;
import weissmoon.electromagictools.block.tile.SolarRegistry;
import weissmoon.electromagictools.client.item.SolarIItemRenderer;
import weissmoon.electromagictools.lib.Strings;

public class ItemBlockSolar
extends WeissItemBlock
implements IItemRenderCustom {
    private final boolean compressed;
    private IIcon[] itemIconArray;
    private String[] icon = new String[]{"solarbasic", "solaraqua", "solarperditio", "solarordo", "solarignis", "solaraer", "solarterra"};

    public ItemBlockSolar(boolean compressed) {
        super(compressed ? ModBlocks.solarGeneratorCompressed : ModBlocks.solarGenerator);
        this.compressed = compressed;
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            int s = this.compressed ? 7 : 15;
            int i = 0;
            while (i < s) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                list.add((Object)stack);
                if (++i != 7) continue;
                ++i;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        PlayerHandler handler = PlayerHandler.getClientPlayerHandler();
        if (handler.hasEUReader()) {
            int tileID = stack.func_77960_j();
            if (stack.func_77973_b() instanceof ItemBlockSolar && !this.compressed) {
                switch (tileID) {
                    case 0: {
                        SolarRegistry.compressed1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 1: {
                        SolarRegistry.aqua1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 2: {
                        SolarRegistry.perditio1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 3: {
                        SolarRegistry.ordo1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 4: {
                        SolarRegistry.ignis1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 5: {
                        SolarRegistry.aer1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 6: {
                        SolarRegistry.terra1.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 8: {
                        SolarRegistry.compressed2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 9: {
                        SolarRegistry.aqua2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 10: {
                        SolarRegistry.perditio2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 11: {
                        SolarRegistry.ordo2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 12: {
                        SolarRegistry.ignis2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 13: {
                        SolarRegistry.aer2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 14: {
                        SolarRegistry.terra2.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                }
            } else {
                switch (tileID) {
                    case 0: {
                        SolarRegistry.compressed3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 1: {
                        SolarRegistry.aqua3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 2: {
                        SolarRegistry.perditio3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 3: {
                        SolarRegistry.ordo3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 4: {
                        SolarRegistry.ignis3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 5: {
                        SolarRegistry.aer3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                    case 6: {
                        SolarRegistry.terra3.addInformation(stack, worldIn, tooltip, flagIn);
                        break;
                    }
                }
            }
        }
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77653_i(ItemStack itemstack) {
        String sub = "Null";
        try {
            int i = itemstack.func_77960_j();
            boolean c = i > 7;
            sub = this.icon[c ? i - 8 : i];
            String aspect = new TextComponentTranslation("tile.welectromagic:" + sub + ".name", new Object[0]).func_150261_e();
            String name = new TextComponentTranslation("tile.welectromagic:blockSolarPanel.name", new Object[]{aspect}).func_150261_e();
            if (this.compressed) {
                return new TextComponentTranslation("tile.welectromagic:solarTriple.name", new Object[]{name}).func_150261_e();
            }
            if (c) {
                return new TextComponentTranslation("tile.welectromagic:solarDouble.name", new Object[]{name}).func_150261_e();
            }
            return name;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return "item.welectromagic:itemMaterial" + sub;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        int i = stack.func_77960_j();
        try {
            if (this.itemIconArray[i] != null) {
                return this.itemIconArray[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return this.itemIconWeiss;
    }

    public void registerIcons(IIconRegister iconRegister) {
        int x;
        this.itemIconArray = new IIcon[Strings.Items.Materials.length];
        int n = this.compressed ? 3 : 1;
        int n2 = x = this.compressed ? 7 : 15;
        for (int i = 0; i < x; ++i) {
            if (i == 7) {
                n = 2;
                continue;
            }
            this.itemIconArray[i] = iconRegister.registerIcon((Item)this, "blocks/" + this.icon[i > 7 ? i - 8 : i] + n);
        }
        super.registerIcons(iconRegister);
    }

    public IItemRenderer getIItemRender() {
        return new SolarIItemRenderer();
    }
}

