/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.item.WeissItem;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.network.FlameParticleMessage;
import weissmoon.electromagictools.network.PacketHandler;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemEntropyStaff
extends WeissItem
implements IDamagelessElectricItem {
    ResourceLocation sound = new ResourceLocation("block.fire.extinguish");
    public int operationEnergyCost = 600;
    public int maxCharge = 30000;
    public int transferLimit = 200;
    public int tier = 2;

    public ItemEntropyStaff() {
        super("itemEntropyStaff");
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (ElectricItem.manager.canUse(stack, (double)this.operationEnergyCost) || player.func_184812_l_()) {
            IBlockState toPlace;
            IBlockState state = worldIn.func_180495_p(pos);
            ItemStack toSmelt = state.func_177230_c().getPickBlock(state, new RayTraceResult(RayTraceResult.Type.BLOCK, new Vec3d((double)hitX, (double)hitY, (double)hitZ), facing, pos), worldIn, pos, player);
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(toSmelt);
            if (result.func_77973_b() instanceof ItemBlock && worldIn.func_180501_a(pos, toPlace = ((ItemBlock)result.func_77973_b()).func_179223_d().getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, result.func_77952_i(), (EntityLivingBase)player, hand), 3)) {
                worldIn.func_184133_a(player, pos, new SoundEvent(this.sound), SoundCategory.BLOCKS, 1.0f, 1.0f);
                if (!worldIn.field_72995_K) {
                    PacketHandler.INSTANCE.sendToDimension((IMessage)new FlameParticleMessage(pos), worldIn.field_73011_w.getDimension());
                }
                if (!player.func_184812_l_()) {
                    ElectricItem.manager.use(stack, (double)this.operationEnergyCost, (EntityLivingBase)player);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }
}

