/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.chainsaw;

import com.google.common.collect.ImmutableSet;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.item.WeissItemElectricTool;
import weissmoon.electromagictools.lib.Strings;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemDiamondChainsaw
extends WeissItemElectricTool {
    protected int hitCost;
    protected double transferLimit;
    protected double field_77865_bY;
    private static final String SHEARMODE_NBT_TAG = "shearsMode";

    public ItemDiamondChainsaw() {
        this(Item.ToolMaterial.DIAMOND, 13.0f, 0.0f, "itemDiamondChainsaw", 10000, 50, 100, 1);
    }

    public ItemDiamondChainsaw(Item.ToolMaterial material, float damage, float speed, String name, int maxCharge, int operationEnergyCost, int transferLimit, int tier) {
        super(1.0f - material.func_78000_c(), speed, material, name);
        this.field_77865_bY = damage;
        this.maxCharge = maxCharge;
        this.operationEnergyCost = operationEnergyCost;
        this.hitCost = operationEnergyCost + 100;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.field_77864_a = 10.0f;
        this.setHarvestLevel("axe", 3);
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (!tag.func_74767_n(SHEARMODE_NBT_TAG)) {
            tooltip.add(Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NORMAL.getLocalized());
        } else {
            tooltip.add(Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NO_SHEAR.getLocalized());
        }
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), Strings.LocaleComps.DIAMOND_CHAINSAW_SHEAR_TOGGLE.getLocalized()}));
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTHelper.setBoolean((ItemStack)stack, (String)SHEARMODE_NBT_TAG, (boolean)true);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, (double)this.operationEnergyCost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(state, stack) || Items.field_151097_aZ.canHarvestBlock(state, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        if (!ElectricItem.manager.canUse(stack, (double)this.operationEnergyCost)) {
            return 1.0f;
        }
        if (Items.field_151056_x.func_150893_a(stack, block) > 1.0f || Items.field_151048_u.func_150893_a(stack, block) > 1.0f) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            if (ElectricItem.manager.use(stack, (double)this.hitCost, attacker)) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), (float)this.field_77865_bY);
            } else {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
            }
            if (target.func_110143_aJ() <= 0.0f) {
                if (target instanceof EntityCreeper) {
                    IC2.achievements.issueStat((EntityPlayer)attacker, "killCreeperChainsaw");
                }
                IC2.achievements.issueStat((EntityPlayer)attacker, "chainsawKills");
            }
            return false;
        }
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (IC2.platform.isSimulating() && IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (tag.func_74767_n(SHEARMODE_NBT_TAG)) {
                tag.func_74757_a(SHEARMODE_NBT_TAG, false);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NORMAL);
            } else {
                tag.func_74757_a(SHEARMODE_NBT_TAG, true);
                IC2.platform.messagePlayer(player, TextFormatting.RED, Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NO_SHEAR);
            }
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, handIn);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (NBTHelper.getBoolean((ItemStack)itemstack, (String)SHEARMODE_NBT_TAG) || player.field_70170_p.field_72995_K) {
            return false;
        }
        IBlockState block = player.field_70170_p.func_180495_p(pos);
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(itemstack, (IBlockAccess)player.field_70170_p, pos)) {
            List drops = target.onSheared(itemstack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)itemstack));
            Random rand = new Random();
            for (ItemStack stack : drops) {
                float f = 0.7f;
                double xOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double yOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double zOffset = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset, stack);
                entityitem.func_174869_p();
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            player.func_71029_a(StatList.func_188055_a((Block)block.func_177230_c()));
        }
        return false;
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (!NBTHelper.getBoolean((ItemStack)stack, (String)SHEARMODE_NBT_TAG) || player.field_70170_p.field_72995_K) {
            return false;
        }
        if (target instanceof IShearable) {
            BlockPos tatgetPos = new BlockPos((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v);
            if (((IShearable)target).isShearable(stack, (IBlockAccess)target.field_70170_p, tatgetPos)) {
                List drops = ((IShearable)target).onSheared(stack, (IBlockAccess)target.field_70170_p, tatgetPos, EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)stack));
                Random rand = new Random();
                for (ItemStack istack : drops) {
                    EntityItem ent = target.func_70099_a(istack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            return true;
        }
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"axe");
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }
}

