/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.chainsaw;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.enchantment.EnumInfusionEnchantment;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.Utils;
import weissmoon.electromagictools.item.tool.chainsaw.ItemDiamondChainsaw;
import weissmoon.electromagictools.util.GenericHelper;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemStreamChainsaw
extends ItemDiamondChainsaw {
    public ItemStreamChainsaw() {
        super(ThaumcraftMaterials.TOOLMAT_ELEMENTAL, 19.0f, 0.0f, "itemStreamChainsaw", 1000000, 400, 900, 2);
        this.field_77864_a = 25.0f;
    }

    public int func_77626_a(ItemStack stack) {
        return 7200;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        if (IC2.platform.isSimulating()) {
            if (IC2.keyboard.isModeSwitchKeyDown(player)) {
                return super.func_77659_a(world, player, handIn);
            }
            player.func_184598_c(handIn);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(handIn));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(handIn));
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        World worldIn = player.func_130014_f_();
        if (worldIn.func_82737_E() % 2L == 0L) {
            if (!(player instanceof EntityPlayer)) {
                return;
            }
            if (!player.func_184587_cr()) {
                return;
            }
            double x = player.field_70165_t;
            double y = player.field_70163_u + 1.5;
            double z = player.field_70161_v;
            int pulled = 0;
            for (EntityItem item : worldIn.func_72872_a(EntityItem.class, new AxisAlignedBB(x, y, z, x + 1.0, y + 1.0, z + 1.0).func_186662_g(10.0))) {
                if (item.getEntityData().func_74767_n("PreventRemoteMovement")) continue;
                if (!this.canPull(stack) || pulled > 200) break;
                double xd = item.field_70165_t - player.field_70165_t;
                double yd = item.field_70163_u - player.field_70163_u + (double)(player.field_70131_O / 2.0f);
                double zd = item.field_70161_v - player.field_70161_v;
                double distance = Math.sqrt(xd * xd + yd * yd + zd * zd);
                item.field_70159_w -= GenericHelper.minMaxClamp(-0.25, 0.25, xd /= distance);
                item.field_70181_x -= GenericHelper.minMaxClamp(-0.25, 0.25, yd /= distance);
                item.field_70179_y -= GenericHelper.minMaxClamp(-0.25, 0.25, zd /= distance);
                ElectricItem.manager.use(stack, (double)((float)this.operationEnergyCost / 2.0f), player);
                ++pulled;
                FXDispatcher.INSTANCE.crucibleBubble((float)item.field_70165_t + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f, (float)item.field_70163_u + item.field_70131_O + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f, (float)item.field_70161_v + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f, 0.33f, 0.33f, 1.0f);
            }
        }
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return oldStack.func_77973_b() == newStack.func_77973_b();
    }

    public boolean canPull(ItemStack stack) {
        return ElectricItem.manager.canUse(stack, (double)((float)this.operationEnergyCost / 2.0f));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        entityLiving.func_184602_cy();
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && Utils.isWoodLog((IBlockAccess)world, (BlockPos)pos) && ElectricItem.manager.canUse(player.func_184614_ca(), (double)this.operationEnergyCost)) {
            if (!world.field_72995_K && BlockUtils.breakFurthestBlock((World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos), (EntityPlayer)player)) {
                world.func_184133_a(null, pos, new SoundEvent(new ResourceLocation("thaumcraft:bubble")), SoundCategory.PLAYERS, 0.15f, 1.0f);
                ElectricItem.manager.use(player.func_184614_ca(), (double)this.operationEnergyCost, (EntityLivingBase)player);
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        IBlockState state = player.field_70170_p.func_180495_p(pos);
        if (!player.func_70093_af() && Utils.isWoodLog((IBlockAccess)player.field_70170_p, (BlockPos)pos) && ElectricItem.manager.canUse(player.func_184614_ca(), (double)this.operationEnergyCost) && !player.field_70170_p.field_72995_K && BlockUtils.breakFurthestBlock((World)player.field_70170_p, (BlockPos)pos, (IBlockState)state, (EntityPlayer)player)) {
            player.field_70170_p.func_184133_a(null, pos, new SoundEvent(new ResourceLocation("thaumcraft:bubble")), SoundCategory.PLAYERS, 0.15f, 1.0f);
            ElectricItem.manager.use(itemstack, (double)this.operationEnergyCost, (EntityLivingBase)player);
            return true;
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.BURROWING, (int)1);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.COLLECTOR, (int)1);
            list.add((Object)stack);
            stack = ItemHelper.getChargedItem((IElectricItem)this, 1);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.BURROWING, (int)1);
            EnumInfusionEnchantment.addInfusionEnchantment((ItemStack)stack, (EnumInfusionEnchantment)EnumInfusionEnchantment.COLLECTOR, (int)1);
            list.add((Object)stack);
        }
    }
}

