/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.drill;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import ic2.api.classic.item.IMiningDrill;
import ic2.api.classic.item.IScannerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.core.IC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thaumcraft.api.ThaumcraftMaterials;
import weissmoon.electromagictools.ElectroMagicTools;
import weissmoon.electromagictools.item.WeissItemElectricTool;
import weissmoon.electromagictools.util.BlockUtils;
import weissmoon.electromagictools.util.ItemHelper;

public class ItemThaumiumDrill
extends WeissItemElectricTool
implements IMiningDrill {
    protected double transferLimit = 0.0;
    final ItemStack torch = new ItemStack(Blocks.field_150478_aa);

    public ItemThaumiumDrill() {
        this(ThaumcraftMaterials.TOOLMAT_THAUMIUM, "itemThaumiumDrill", 100000, 100, 2);
        this.operationEnergyCost = 250;
        this.field_77864_a = 20.0f;
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    public ItemThaumiumDrill(Item.ToolMaterial material, String name, int maxCharge, int transferLimit, int tier) {
        super(1.0f - material.func_78000_c(), -3.0f, material, name);
        this.maxCharge = maxCharge;
        this.operationEnergyCost = 0;
        this.tier = tier;
        this.transferLimit = transferLimit;
        this.field_77864_a = 0.0f;
        this.func_77637_a((CreativeTabs)ElectroMagicTools.EMTtab);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound nbt = StackUtil.getNbtData((ItemStack)stack);
        tooltip.add((nbt.func_74767_n("dirtMode") ? Ic2InfoLang.enableDrillMode : Ic2InfoLang.disableDrillMode).getLocalized());
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), Ic2InfoLang.drillModeSwitch.getLocalized()}));
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(0), Ic2InfoLang.drillProbing.getLocalized()}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ItemHelper.getElectricDurability(stack);
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState block, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            if (!entityLiving.func_70093_af()) {
                for (int a = 1; a < 8 && (world.func_180495_p(pos.func_177981_b(a)).func_177230_c() == Blocks.field_150351_n || world.func_180495_p(pos.func_177981_b(a)).func_177230_c() == Blocks.field_150354_m); ++a) {
                    EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_185262_c((int)35), (ItemStack)stack);
                    if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) continue;
                    IBlockState iblockstate = world.func_180495_p(pos.func_177981_b(a));
                    BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos.func_177981_b(a), iblockstate, (EntityPlayer)entityLiving);
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (event.isCanceled() || !BlockUtils.breakBlock(world, pos.func_177981_b(a), (EntityPlayer)entityLiving, stack, event.getExpToDrop())) continue;
                    ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), entityLiving);
                    IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
                }
            }
            ElectricItem.manager.use(stack, (double)this.getEnergyCost(stack), entityLiving);
            IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
        }
        return true;
    }

    public boolean canHarvestBlock(IBlockState block, ItemStack stack) {
        return Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151047_v.canHarvestBlock(block, stack);
    }

    public float func_150893_a(ItemStack stack, IBlockState block) {
        if (!ElectricItem.manager.canUse(stack, (double)this.getEnergyCost(stack))) {
            return 1.0f;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (nbt.func_74767_n("dirtMode") && block.func_185904_a() == Material.field_151578_c) {
            return this.field_77864_a / 8.0f;
        }
        if (Items.field_151046_w.func_150893_a(stack, block) > 1.0f || Items.field_151047_v.func_150893_a(stack, block) > 1.0f) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, block);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase player) {
        ElectricItem.manager.use(itemstack, (double)this.operationEnergyCost, player);
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 8;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            double attackDamage = 1.5;
            if (ElectricItem.manager.canUse(stack, (double)((ItemThaumiumDrill)stack.func_77973_b()).operationEnergyCost)) {
                attackDamage = 5.5;
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Tool modifier", attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.field_185065_c, 0));
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            list.add((Object)stack);
            list.add((Object)ItemHelper.getChargedItem((IElectricItem)this, 1));
        }
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"pickaxe", (Object)"shovel");
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    public int getTier(ItemStack stack) {
        return this.tier;
    }

    public double getTransferLimit(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean isBasicDrill(ItemStack drill) {
        return false;
    }

    public int getExtraSpeed(ItemStack drill) {
        int pointBoost = this.getPointBoost(drill);
        return pointBoost + 5;
    }

    private int getPointBoost(ItemStack drill) {
        int lvl = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        return lvl <= 0 ? 0 : lvl * lvl + 1;
    }

    public int getExtraEnergyCost(ItemStack drill) {
        int points = this.getEnergyChange(drill) + 21;
        return Math.max(points, 0);
    }

    public int getEnergyChange(ItemStack drill) {
        int eff = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)drill);
        int unb = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)drill);
        int points = eff * eff + 1;
        return points -= unb * (unb + unb);
    }

    public void useDrill(ItemStack drill) {
        ElectricItem.manager.use(drill, (double)this.operationEnergyCost * 0.95, null);
    }

    public boolean canMine(ItemStack drill) {
        return ElectricItem.manager.getCharge(drill) >= (double)this.operationEnergyCost * 0.95;
    }

    public boolean canMineBlock(ItemStack drill, IBlockState state, IBlockAccess access, BlockPos pos) {
        return ForgeHooks.canToolHarvestBlock((IBlockAccess)access, (BlockPos)pos, (ItemStack)drill);
    }

    public EnumEnchantmentType getType(ItemStack itemStack) {
        return EnumEnchantmentType.DIGGER;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.keyboard.isModeSwitchKeyDown(playerIn)) {
            if (IC2.platform.isRendering()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
            boolean result = !nbt.func_74767_n("dirtMode");
            nbt.func_74757_a("dirtMode", result);
            IC2.platform.messagePlayer(playerIn, result ? Ic2InfoLang.enableDrillMode : Ic2InfoLang.disableDrillMode);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2.keyboard.isAltKeyDown(playerIn) && !this.getScanner(playerIn.field_71071_by).func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    public ItemStack getScanner(InventoryPlayer player) {
        ItemStack stack;
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.func_70301_a(i);
            if (!(stack2.func_77973_b() instanceof IScannerItem)) continue;
            result = stack2;
            break;
        }
        if (result.func_190926_b() && (stack = player.field_70458_d.func_184592_cb()).func_77973_b() instanceof IScannerItem) {
            result = stack;
        }
        return result;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isAltKeyDown(player)) {
            return Ic2Items.diamondDrill.func_179546_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        if (!ElectroMagicTools.gtcxLoaded) {
            return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        IBlockState state = worldIn.func_180495_p(pos);
        Block block = state.func_177230_c();
        ItemStack stack = ItemStack.field_190927_a;
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        for (ItemStack stack1 : player.field_71071_by.field_70462_a) {
            if (stack1.func_77973_b() != this.torch.func_77973_b()) continue;
            stack = stack1;
            break;
        }
        if (!stack.func_190926_b() && player.func_175151_a(pos, facing, stack) && worldIn.func_190527_a(Blocks.field_150478_aa, pos, false, facing, (Entity)player)) {
            IBlockState state1 = Blocks.field_150478_aa.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, 0, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, worldIn, pos, facing, hitX, hitY, hitZ, state1)) {
                state1 = worldIn.func_180495_p(pos);
                SoundType soundtype = state1.func_177230_c().getSoundType(state1, worldIn, pos, (Entity)player);
                worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 11)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150478_aa) {
            ItemBlock.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            Blocks.field_150478_aa.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            if (player instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193137_x.func_193173_a((EntityPlayerMP)player, pos, stack);
            }
        }
        return true;
    }
}

