/*
 * Decompiled with CFR 0.152.
 */
package weissmoon.electromagictools.item.tool.omnitool;

import ic2.api.classic.item.IScannerItem;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import weissmoon.core.utils.NBTHelper;
import weissmoon.electromagictools.item.tool.omnitool.ItemIronOmniTool;
import weissmoon.electromagictools.lib.Strings;
import weissmoon.electromagictools.util.BlockUtils;

public class ItemDiamondOmniTool
extends ItemIronOmniTool {
    protected static String NBT_DIRT_MODE = "dirtMode";

    public ItemDiamondOmniTool() {
        super(9, Item.ToolMaterial.DIAMOND, "itemDiamondOmniTool", 100000, 400, 1);
        this.operationEnergyCost = 200;
        this.field_77864_a = 16.0f;
    }

    public ItemDiamondOmniTool(int attackDamage, Item.ToolMaterial material, String name, int maxCharge, int transferLimit, int tier) {
        super(attackDamage, material, name, maxCharge, transferLimit, tier);
    }

    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        tooltip.add((!tag.func_74767_n("shearsMode") ? Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NORMAL : Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NO_SHEAR).getLocalized());
        tooltip.add((tag.func_74767_n(NBT_DIRT_MODE) ? Ic2InfoLang.enableDrillMode : Ic2InfoLang.disableDrillMode).getLocalized());
        List<String> ctrlTip = sortedTooltip.get(ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(2), Strings.LocaleComps.DIAMOND_OMNITOOL_TOGGLE.getLocalized()}));
        ctrlTip.add("");
        ctrlTip.add(Ic2Lang.onBlockClick.getLocalized());
        ctrlTip.add(Ic2Lang.pressTo.getLocalizedFormatted(new Object[]{IC2.keyboard.getKeyName(0), Ic2InfoLang.drillProbing.getLocalized()}));
    }

    @Override
    public boolean canHarvestBlock(IBlockState block, ItemStack stack) {
        return Items.field_151056_x.func_150897_b(block) || Items.field_151047_v.func_150897_b(block) || Items.field_151046_w.func_150897_b(block) || Items.field_151048_u.func_150897_b(block) || block.func_177230_c() instanceof IShearable;
    }

    @Override
    public float func_150893_a(ItemStack stack, IBlockState block) {
        if (!ElectricItem.manager.canUse(stack, (double)this.operationEnergyCost)) {
            return 1.0f;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (nbt.func_74767_n(NBT_DIRT_MODE) && block.func_185904_a() == Material.field_151578_c) {
            return this.field_77864_a / 8.0f;
        }
        return super.func_150893_a(stack, block);
    }

    @Override
    public boolean toolSpeed(ItemStack stack, IBlockState block) {
        return Items.field_151056_x.func_150893_a(stack, block) > 1.0f || Items.field_151047_v.func_150893_a(stack, block) > 1.0f || Items.field_151046_w.func_150893_a(stack, block) > 1.0f || Items.field_151048_u.func_150893_a(stack, block) > 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        NBTTagCompound tag = StackUtil.getOrCreateNbtData((ItemStack)stack);
        if (IC2.keyboard.isModeSwitchKeyDown(player)) {
            if (IC2.platform.isRendering()) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
            }
            BreakModes mode = BreakModes.fromBool(tag.func_74767_n("shearsMode"), tag.func_74767_n(NBT_DIRT_MODE)).cycle(player);
            tag.func_74757_a(NBT_DIRT_MODE, mode.dirtMode);
            tag.func_74757_a("shearsMode", mode.shearMode);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (IC2.keyboard.isAltKeyDown(player) && !this.getScanner(player.field_71071_by).func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, handIn);
    }

    public ItemStack getScanner(InventoryPlayer player) {
        ItemStack stack;
        ItemStack result = ItemStack.field_190927_a;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack2 = player.func_70301_a(i);
            if (!(stack2.func_77973_b() instanceof IScannerItem)) continue;
            result = stack2;
            break;
        }
        if (result.func_190926_b() && (stack = player.field_70458_d.func_184592_cb()).func_77973_b() instanceof IScannerItem) {
            result = stack;
        }
        return result;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (IC2.keyboard.isAltKeyDown(player)) {
            return Ic2Items.diamondDrill.func_179546_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (NBTHelper.getBoolean((ItemStack)itemstack, (String)"shearsMode") || player.field_70170_p.field_72995_K) {
            return false;
        }
        return Ic2Items.chainSaw.func_77973_b().onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer && !entityLiving.func_70093_af()) {
            for (int a = 1; a < 8 && (worldIn.func_180495_p(pos.func_177981_b(a)).func_177230_c() == Blocks.field_150351_n || worldIn.func_180495_p(pos.func_177981_b(a)).func_177230_c() == Blocks.field_150354_m); ++a) {
                EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_185262_c((int)35), (ItemStack)stack);
                if (!ElectricItem.manager.canUse(stack, (double)this.operationEnergyCost)) continue;
                IBlockState iblockstate = worldIn.func_180495_p(pos.func_177981_b(a));
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(worldIn, pos.func_177981_b(a), iblockstate, (EntityPlayer)entityLiving);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled() || !BlockUtils.breakBlock(worldIn, pos.func_177981_b(a), (EntityPlayer)entityLiving, stack, event.getExpToDrop())) continue;
                ElectricItem.manager.use(stack, (double)this.operationEnergyCost, entityLiving);
                IC2.achievements.issueStat((EntityPlayer)entityLiving, "blocksDrilled");
            }
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (NBTHelper.getBoolean((ItemStack)stack, (String)"shearsMode") || player.field_70170_p.field_72995_K) {
            return false;
        }
        if (target instanceof IShearable) {
            BlockPos tatgetPos = new BlockPos((int)target.field_70165_t, (int)target.field_70163_u, (int)target.field_70161_v);
            if (((IShearable)target).isShearable(stack, (IBlockAccess)target.field_70170_p, tatgetPos)) {
                List drops = ((IShearable)target).onSheared(stack, (IBlockAccess)target.field_70170_p, tatgetPos, EnchantmentHelper.func_77506_a((Enchantment)Enchantment.func_180305_b((String)"fortune"), (ItemStack)stack));
                Random rand = new Random();
                for (ItemStack istack : drops) {
                    EntityItem ent = target.func_70099_a(istack, 1.0f);
                    ent.field_70181_x += (double)(rand.nextFloat() * 0.05f);
                    ent.field_70159_w += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                    ent.field_70179_y += (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int func_77619_b() {
        return 4;
    }

    @Override
    public int getExtraSpeed(ItemStack drill) {
        return 3 + super.getExtraSpeed(drill);
    }

    @Override
    public int getExtraEnergyCost(ItemStack drill) {
        return 14 + super.getExtraEnergyCost(drill);
    }

    static enum BreakModes {
        SHEARMODE_AND_DIRTMODE(false, true),
        SHEARMODE_ONLY(false, false),
        DIRTMODE_ONLY(true, true),
        NEITHER(true, false);

        boolean shearMode;
        boolean dirtMode;

        private BreakModes(boolean shearMode, boolean dirtMode) {
            this.shearMode = shearMode;
            this.dirtMode = dirtMode;
        }

        static BreakModes fromBool(boolean shear, boolean dirt) {
            if (!shear && dirt) {
                return SHEARMODE_AND_DIRTMODE;
            }
            if (!shear) {
                return SHEARMODE_ONLY;
            }
            if (dirt) {
                return DIRTMODE_ONLY;
            }
            return NEITHER;
        }

        BreakModes cycle(EntityPlayer player) {
            if (this == SHEARMODE_AND_DIRTMODE) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.disableDrillMode);
                return SHEARMODE_ONLY;
            }
            if (this == SHEARMODE_ONLY) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NO_SHEAR);
                IC2.platform.messagePlayer(player, TextFormatting.GREEN, Ic2InfoLang.enableDrillMode);
                return DIRTMODE_ONLY;
            }
            if (this == DIRTMODE_ONLY) {
                IC2.platform.messagePlayer(player, TextFormatting.RED, Ic2InfoLang.disableDrillMode);
                return NEITHER;
            }
            IC2.platform.messagePlayer(player, TextFormatting.GREEN, Strings.LocaleComps.MESSAGE_DIAMOND_CHAINSAW_NORMAL);
            IC2.platform.messagePlayer(player, TextFormatting.GREEN, Ic2InfoLang.enableDrillMode);
            return SHEARMODE_AND_DIRTMODE;
        }
    }
}

